-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local system_info = require 'domain.system_info.system_info'
local prop_def = require 'macros.property_def'
local ipmi = require 'ipmi'
local cc = ipmi.types.Cc

local CharacterInfo = class(system_info)

function CharacterInfo:ctor(cfg)
    self.cfg = cfg
end

function CharacterInfo:init()
    CharacterInfo.super.init(self)
    local data = ''
    if self.db_obj and self.db_obj[self.prop] then
        data = self.db_obj[self.prop]
    end
    self.data = data
end

--持久化
function CharacterInfo:save()
    if not self.db_obj or self.db_obj[self.prop] == nil then
        log:error('bios: save block prop %s invalid param', self.prop)
        return false
    end
    self.db_obj[self.prop] = self.data
    self.db_obj:save()
    return true
end

function CharacterInfo:set_info(data)
    self.data = data
    if not self:save() then
        return cc.InvalidFieldRequest
    end
    return cc.Success
end

function CharacterInfo:get_info()
    if not self.data or #self.data == 0 then
        log:error('get system info failed, data is nil')
        return cc.InvalidFieldRequest, prop_def.ParameterRevision, ''
    end
    return cc.Success, prop_def.ParameterRevision, self.data
end

return CharacterInfo