-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 管理策略重配的配置当前值
local class = require 'mc.class'
local utils = require 'mc.utils'
local json = require 'cjson'
local log = require 'mc.logging'
local bios_enum = require 'domain.bios_firmware.defs'
local component_info = require 'domain.mapping.component_info'
local file_util = require 'infrastructure.file_util'
local bs_util = require 'util.base_util'

local PolicyConfigValue = class(component_info)
local BIOS_CONFIG_VALUEFILE_DIR<const> = '/data/opt/bmc/conf/bios/'

function PolicyConfigValue:ctor(system_id)
    local real_system_id = system_id or 1
    self.file_path = bs_util.get_conf_path(real_system_id, 'ConfigValue.json')
    self.type = bios_enum.ReadImuFileType.Current
    utils.mkdir_with_parents(BIOS_CONFIG_VALUEFILE_DIR, utils.S_IRWXU | utils.S_IRGRP | utils.S_IXGRP)
    PolicyConfigValue.super.init_info(self, real_system_id)
end

function PolicyConfigValue:init()
    PolicyConfigValue.super.start_task(self)
end

-- 更新资源树上的版本号
function PolicyConfigValue:update_cfg_version()
end

local function cal_crc(data)
    if not data then
        return 0
    end
    local ok, crc = pcall(function()
        return crc32(data, 0, true)
    end)
    if not ok then
        return 0
    end
    return crc
end

function PolicyConfigValue:update_user_data(user_content_json)
    local current_json = json.json_object_ordered_decode(self.data)
    for k, v in pairs(user_content_json) do
        if current_json[k] then
            current_json[k] = v
        end
    end
    PolicyConfigValue.super.update_data(self, json.json_object_ordered_encode(current_json))
    file_util.write_file_data(self.file_path, self.data)
end

return PolicyConfigValue