-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 管理策略重配的标准文件
local class = require 'mc.class'
local utils = require 'mc.utils'
local json = require 'cjson'
local log = require 'mc.logging'
local bios_enum = require 'domain.bios_firmware.defs'
local component_info = require 'domain.mapping.component_info'
local bs_util = require 'util.base_util'

local PolicyConfigRegistery = class(component_info)
local BIOS_POLICY_CONFIG_FILE_DIR<const> = '/data/opt/bmc/conf/bios/'

function PolicyConfigRegistery:ctor(system_id)
    local real_system_id = system_id or 1
    self.file_path = bs_util.get_conf_path(real_system_id, 'PolicyConfigRegistry.json')
    self.type = bios_enum.ReadImuFileType.Registery
    utils.mkdir_with_parents(BIOS_POLICY_CONFIG_FILE_DIR, utils.S_IRWXU | utils.S_IRGRP | utils.S_IXGRP)
    PolicyConfigRegistery.super.init_info(self, real_system_id)
end

function PolicyConfigRegistery:init()
end

return PolicyConfigRegistery