-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local process_channel = require 'domain.bios_firmware.package.channel.firmware_process_channel'
local spi_flash = require 'libmgmt_protocol.bios.infrastructure.spi_flash'
local skynet = require 'skynet'
local SpiFlashChannel = class(process_channel)

local E_OK<const> = 0
function SpiFlashChannel:ctor()
    SpiFlashChannel.super.ctor(self, 'FlashChannel')
end

function SpiFlashChannel:upgrade(ctx, properties)
    if not ctx or not properties or not ctx.BinPath or
        not ctx.DeviceName or not properties.Offset or not properties.Length then
        error('spi channel: invalid param')
    end
    skynet.sleep(50)
    if spi_flash.spi_flash_copy(ctx.BinPath, ctx.DeviceName,
        properties.Offset, properties.Length) ~= E_OK then
        error('write update region to flash failed')
    end
end

return SpiFlashChannel