-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bios_def = {}

bios_def.err_code = {
    ERR_INVALID_FILE_NAME = -5001, -- 文件名无效
    ERR_INVALID_WRITE_CONTENT = -5002, -- 要写入文件的内容无效
    ERR_FILE_NOT_SUPPORT_WRITE = -5003, -- 文件不支持写操作
    ERR_NOT_SUPPORT_BIOS_MGNT = -5004  -- 环境不支持BIOS资源管理
}

bios_def.regist_prop_err = {
    UNKNOWN = 2, -- 属性未知
    IMMUTABLE = 3, -- 属性不可变更
    READONLY = 4, -- 属性只读
    NOT_LIST = 5, -- 枚举不在列表中
    LENGTH_ERR = 6, -- 字符串长度不在范围类
    FORMAT_ERR = 7, -- 正则表达式校验失败
    NOT_RANGE = 8, -- 整型数字不在范围类
    TYPE_ERROR = 9, -- 类型错误
    SCALAR_INCREMENT = 10, -- 整型变化范围错误
    HIDE = 11, -- 属性被隐藏
    BOOTTYPEORDER_ERROR = 20  -- 启动顺序错误
}

bios_def.start_option_flag = {
    EFFECTIVE_NONE = 0X00,
    EFFECTIVE_ONCE = 0X01,
    EFFECTIVE_FOREVER = 0X02
}

bios_def.start_option_type = {
    NONE = 0X00,
    PXE = 0X01,
    HDD = 0X02,
    CD = 0X05,
    BIOS_SET_UP = 0X06,
    FLOPPY = 0X0F
}

return bios_def