-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local skynet = require 'skynet'
local log = require 'mc.logging'
local manufacture_app = class()

function manufacture_app.new(app)
    return setmetatable({app = app}, manufacture_app)
end

function manufacture_app:init()
    log:notice('[bios]manufacture app set dft mode start')
    local cnt = 1
    while cnt < 100 do
        local ok, res = pcall(function()
            return self.app:set_dft_mode()
        end)
        if ok and res then
            log:notice('[bios]manufacture app set dft mode success')
            return
        end
        skynet.sleep(100)
    end
    log:error('[bios]manufacture app set dft mode fail')
end

return manufacture_app