-- Copyright (c) Huawei Technologies Co., Ltd. 2025-2025. All rights reserved.
-- 
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
local M = {}

function M.decode(type, length, handle, read_fields, strings)
    if length < 0x0F then
        return
    end

    local t = {}

    -- 2.1+
    if length >= 0x0F then
        local fields = read_fields('BBBI4HH')
        t.location = fields[1]
        t.use = fields[2]
        t.memory_error_correction = fields[3]
        t.max_capacity = fields[4]
        t.memory_error_info_handle = fields[5]
        t.memory_device_number = fields[6]
    end

    -- 2.7+
    if length >= 0x17 then
        local fields = read_fields('I4')
        t.extend_max_capacity = fields[1]
    end

    return {Handle = handle, Length = length, Type = type, Strings = strings, Fields = t}
end

return M
