-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local decoder = require 'bios.smbios.decoder'

local smbios_handler = {}
smbios_handler.__index = smbios_handler

function smbios_handler:update()
    log:info('start to parse smbios')
    log:info('%s', self.path)
    local data_collection = decoder.load(self.path)
    if not data_collection then
        log:error("load smbios failed")
        return nil
    end
    self.smbios_processor_info = decoder.get_processor_devices(data_collection)
    self.smbios_memory_info = decoder.get_memory_devices(data_collection)
    self.smbios_cache_info = decoder.get_cache_devices(data_collection)
    self.smbios_memory_array_info = decoder.get_physical_memory_array(data_collection)
end

function smbios_handler.new(system_id, path)
    return setmetatable({
        system_id = system_id,
        path = path,
        smbios_processor_info = {},
        smbios_memory_info = {},
        smbios_cache_info = {},
        smbios_memory_array_info = {}
    }, smbios_handler)
end

function smbios_handler:update_smbios_path(smbios_path)
    self.path = smbios_path
end

-- Processor对象的alias_name是自身的逻辑ID，在SMBios解析时从socket_designation字段解析，在对象中从一般是物理ID-1
function smbios_handler:get_processor_info_in_smbios(alias_name)
    if not self.smbios_processor_info then
        return nil
    end
    return self.smbios_processor_info[alias_name]
end
-- Memory的alias_name是CpuID+0+ChannelID+DimmID拼接得到，在SMBios解析时从device_locator字段解析
function smbios_handler:get_memory_info_in_smbios(alias_name)
    if not self.smbios_memory_info then
        return nil
    end
    return self.smbios_memory_info[alias_name]
end

function smbios_handler:get_memory_array_info_in_smbios(location)
    if not self.smbios_memory_array_info then
        return nil
    end
    return self.smbios_memory_array_info[location]
end

-- cache信息的alias_name是自身的handle，也就是Porcessor对象Fields属性的L1-L3的cache_handle，可以直接拿来作为入参
function smbios_handler:get_cache_info_in_smbios(alias_name)
    if not self.smbios_cache_info then
        return nil
    end
    return self.smbios_cache_info[alias_name]
end

return smbios_handler