-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSPIRate = {}

---@class MSPIRate.Rate
---@field Rate integer
local TRate = {}
TRate.__index = TRate
TRate.group = {}

local function TRate_from_obj(obj)
    return setmetatable(obj, TRate)
end

function TRate.new(Rate)
    return TRate_from_obj({Rate = Rate or 0})
end
---@param obj MSPIRate.Rate
function TRate:init_from_obj(obj)
    self.Rate = obj.Rate or 0
end

function TRate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRate.group)
end

TRate.from_obj = TRate_from_obj

TRate.proto_property = {'Rate'}

TRate.default = {0}

TRate.struct = {{name = 'Rate', is_array = false, struct = nil}}

function TRate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Rate', self.Rate, 'uint8', false, errs, need_convert)

    TRate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRate.proto_property, errs, need_convert)
    return self
end

function TRate:unpack(_)
    return self.Rate
end

MSPIRate.Rate = TRate

return MSPIRate
