-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSPIChannel = {}

---@class MSPIChannel.Switch
---@field Switch integer
local TSwitch = {}
TSwitch.__index = TSwitch
TSwitch.group = {}

local function TSwitch_from_obj(obj)
    return setmetatable(obj, TSwitch)
end

function TSwitch.new(Switch)
    return TSwitch_from_obj({Switch = Switch})
end
---@param obj MSPIChannel.Switch
function TSwitch:init_from_obj(obj)
    self.Switch = obj.Switch
end

function TSwitch:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSwitch.group)
end

TSwitch.from_obj = TSwitch_from_obj

TSwitch.proto_property = {'Switch'}

TSwitch.default = {0}

TSwitch.struct = {{name = 'Switch', is_array = false, struct = nil}}

function TSwitch:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Switch', self.Switch, 'uint8', false, errs, need_convert)

    TSwitch:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSwitch.proto_property, errs, need_convert)
    return self
end

function TSwitch:unpack(_)
    return self.Switch
end

MSPIChannel.Switch = TSwitch

return MSPIChannel
