-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MMemorySilk = {}

---@class MMemorySilk.DimmId
---@field DimmId integer
local TDimmId = {}
TDimmId.__index = TDimmId
TDimmId.group = {}

local function TDimmId_from_obj(obj)
    return setmetatable(obj, TDimmId)
end

function TDimmId.new(DimmId)
    return TDimmId_from_obj({DimmId = DimmId})
end
---@param obj MMemorySilk.DimmId
function TDimmId:init_from_obj(obj)
    self.DimmId = obj.DimmId
end

function TDimmId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDimmId.group)
end

TDimmId.from_obj = TDimmId_from_obj

TDimmId.proto_property = {'DimmId'}

TDimmId.default = {0}

TDimmId.struct = {{name = 'DimmId', is_array = false, struct = nil}}

function TDimmId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DimmId', self.DimmId, 'uint8', false, errs, need_convert)

    TDimmId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDimmId.proto_property, errs, need_convert)
    return self
end

function TDimmId:unpack(_)
    return self.DimmId
end

MMemorySilk.DimmId = TDimmId

---@class MMemorySilk.LogicalChannelId
---@field LogicalChannelId integer
local TLogicalChannelId = {}
TLogicalChannelId.__index = TLogicalChannelId
TLogicalChannelId.group = {}

local function TLogicalChannelId_from_obj(obj)
    return setmetatable(obj, TLogicalChannelId)
end

function TLogicalChannelId.new(LogicalChannelId)
    return TLogicalChannelId_from_obj({LogicalChannelId = LogicalChannelId})
end
---@param obj MMemorySilk.LogicalChannelId
function TLogicalChannelId:init_from_obj(obj)
    self.LogicalChannelId = obj.LogicalChannelId
end

function TLogicalChannelId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicalChannelId.group)
end

TLogicalChannelId.from_obj = TLogicalChannelId_from_obj

TLogicalChannelId.proto_property = {'LogicalChannelId'}

TLogicalChannelId.default = {0}

TLogicalChannelId.struct = {{name = 'LogicalChannelId', is_array = false, struct = nil}}

function TLogicalChannelId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicalChannelId', self.LogicalChannelId, 'uint8', false, errs, need_convert)

    TLogicalChannelId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicalChannelId.proto_property, errs, need_convert)
    return self
end

function TLogicalChannelId:unpack(_)
    return self.LogicalChannelId
end

MMemorySilk.LogicalChannelId = TLogicalChannelId

---@class MMemorySilk.ChannelId
---@field ChannelId integer
local TChannelId = {}
TChannelId.__index = TChannelId
TChannelId.group = {}

local function TChannelId_from_obj(obj)
    return setmetatable(obj, TChannelId)
end

function TChannelId.new(ChannelId)
    return TChannelId_from_obj({ChannelId = ChannelId})
end
---@param obj MMemorySilk.ChannelId
function TChannelId:init_from_obj(obj)
    self.ChannelId = obj.ChannelId
end

function TChannelId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannelId.group)
end

TChannelId.from_obj = TChannelId_from_obj

TChannelId.proto_property = {'ChannelId'}

TChannelId.default = {0}

TChannelId.struct = {{name = 'ChannelId', is_array = false, struct = nil}}

function TChannelId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChannelId', self.ChannelId, 'uint8', false, errs, need_convert)

    TChannelId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannelId.proto_property, errs, need_convert)
    return self
end

function TChannelId:unpack(_)
    return self.ChannelId
end

MMemorySilk.ChannelId = TChannelId

---@class MMemorySilk.CpuId
---@field CpuId integer
local TCpuId = {}
TCpuId.__index = TCpuId
TCpuId.group = {}

local function TCpuId_from_obj(obj)
    return setmetatable(obj, TCpuId)
end

function TCpuId.new(CpuId)
    return TCpuId_from_obj({CpuId = CpuId})
end
---@param obj MMemorySilk.CpuId
function TCpuId:init_from_obj(obj)
    self.CpuId = obj.CpuId
end

function TCpuId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuId.group)
end

TCpuId.from_obj = TCpuId_from_obj

TCpuId.proto_property = {'CpuId'}

TCpuId.default = {0}

TCpuId.struct = {{name = 'CpuId', is_array = false, struct = nil}}

function TCpuId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuId', self.CpuId, 'uint8', false, errs, need_convert)

    TCpuId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuId.proto_property, errs, need_convert)
    return self
end

function TCpuId:unpack(_)
    return self.CpuId
end

MMemorySilk.CpuId = TCpuId

---@class MMemorySilk.DimmName
---@field DimmName string
local TDimmName = {}
TDimmName.__index = TDimmName
TDimmName.group = {}

local function TDimmName_from_obj(obj)
    return setmetatable(obj, TDimmName)
end

function TDimmName.new(DimmName)
    return TDimmName_from_obj({DimmName = DimmName})
end
---@param obj MMemorySilk.DimmName
function TDimmName:init_from_obj(obj)
    self.DimmName = obj.DimmName
end

function TDimmName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDimmName.group)
end

TDimmName.from_obj = TDimmName_from_obj

TDimmName.proto_property = {'DimmName'}

TDimmName.default = {''}

TDimmName.struct = {{name = 'DimmName', is_array = false, struct = nil}}

function TDimmName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DimmName', self.DimmName, 'string', false, errs, need_convert)

    TDimmName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDimmName.proto_property, errs, need_convert)
    return self
end

function TDimmName:unpack(_)
    return self.DimmName
end

MMemorySilk.DimmName = TDimmName

return MMemorySilk
