-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MCachedBiosUpgradeTable = {}

---@class MCachedBiosUpgradeTable.BiosActiveCondition
---@field BiosActiveCondition string
local TBiosActiveCondition = {}
TBiosActiveCondition.__index = TBiosActiveCondition
TBiosActiveCondition.group = {}

local function TBiosActiveCondition_from_obj(obj)
    return setmetatable(obj, TBiosActiveCondition)
end

function TBiosActiveCondition.new(BiosActiveCondition)
    return TBiosActiveCondition_from_obj({BiosActiveCondition = BiosActiveCondition or [=[PowerOff]=]})
end
---@param obj MCachedBiosUpgradeTable.BiosActiveCondition
function TBiosActiveCondition:init_from_obj(obj)
    self.BiosActiveCondition = obj.BiosActiveCondition or [=[PowerOff]=]
end

function TBiosActiveCondition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBiosActiveCondition.group)
end

TBiosActiveCondition.from_obj = TBiosActiveCondition_from_obj

TBiosActiveCondition.proto_property = {'BiosActiveCondition'}

TBiosActiveCondition.default = {''}

TBiosActiveCondition.struct = {{name = 'BiosActiveCondition', is_array = false, struct = nil}}

function TBiosActiveCondition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosActiveCondition', self.BiosActiveCondition, 'string', false, errs, need_convert)

    TBiosActiveCondition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBiosActiveCondition.proto_property, errs, need_convert)
    return self
end

function TBiosActiveCondition:unpack(_)
    return self.BiosActiveCondition
end

MCachedBiosUpgradeTable.BiosActiveCondition = TBiosActiveCondition

---@class MCachedBiosUpgradeTable.CachedBiosUpgradeMode
---@field CachedBiosUpgradeMode integer
local TCachedBiosUpgradeMode = {}
TCachedBiosUpgradeMode.__index = TCachedBiosUpgradeMode
TCachedBiosUpgradeMode.group = {}

local function TCachedBiosUpgradeMode_from_obj(obj)
    return setmetatable(obj, TCachedBiosUpgradeMode)
end

function TCachedBiosUpgradeMode.new(CachedBiosUpgradeMode)
    return TCachedBiosUpgradeMode_from_obj({CachedBiosUpgradeMode = CachedBiosUpgradeMode or 0})
end
---@param obj MCachedBiosUpgradeTable.CachedBiosUpgradeMode
function TCachedBiosUpgradeMode:init_from_obj(obj)
    self.CachedBiosUpgradeMode = obj.CachedBiosUpgradeMode or 0
end

function TCachedBiosUpgradeMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCachedBiosUpgradeMode.group)
end

TCachedBiosUpgradeMode.from_obj = TCachedBiosUpgradeMode_from_obj

TCachedBiosUpgradeMode.proto_property = {'CachedBiosUpgradeMode'}

TCachedBiosUpgradeMode.default = {0}

TCachedBiosUpgradeMode.struct = {{name = 'CachedBiosUpgradeMode', is_array = false, struct = nil}}

function TCachedBiosUpgradeMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CachedBiosUpgradeMode', self.CachedBiosUpgradeMode, 'uint8', false, errs, need_convert)

    TCachedBiosUpgradeMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCachedBiosUpgradeMode.proto_property, errs, need_convert)
    return self
end

function TCachedBiosUpgradeMode:unpack(_)
    return self.CachedBiosUpgradeMode
end

MCachedBiosUpgradeTable.CachedBiosUpgradeMode = TCachedBiosUpgradeMode

---@class MCachedBiosUpgradeTable.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MCachedBiosUpgradeTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MCachedBiosUpgradeTable.Id = TId

return MCachedBiosUpgradeTable
