-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBiosUpgradeService = {}

---@class MBiosUpgradeService.ExportBiosFirmwareRsp
local TExportBiosFirmwareRsp = {}
TExportBiosFirmwareRsp.__index = TExportBiosFirmwareRsp
TExportBiosFirmwareRsp.group = {}

local function TExportBiosFirmwareRsp_from_obj(obj)
    return setmetatable(obj, TExportBiosFirmwareRsp)
end

function TExportBiosFirmwareRsp.new()
    return TExportBiosFirmwareRsp_from_obj({})
end
---@param obj MBiosUpgradeService.ExportBiosFirmwareRsp
function TExportBiosFirmwareRsp:init_from_obj(obj)

end

function TExportBiosFirmwareRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosFirmwareRsp.group)
end

TExportBiosFirmwareRsp.from_obj = TExportBiosFirmwareRsp_from_obj

TExportBiosFirmwareRsp.proto_property = {}

TExportBiosFirmwareRsp.default = {}

TExportBiosFirmwareRsp.struct = {}

function TExportBiosFirmwareRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TExportBiosFirmwareRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosFirmwareRsp.proto_property, errs, need_convert)
    return self
end

function TExportBiosFirmwareRsp:unpack(_)
end

MBiosUpgradeService.ExportBiosFirmwareRsp = TExportBiosFirmwareRsp

---@class MBiosUpgradeService.ExportBiosFirmwareReq
local TExportBiosFirmwareReq = {}
TExportBiosFirmwareReq.__index = TExportBiosFirmwareReq
TExportBiosFirmwareReq.group = {}

local function TExportBiosFirmwareReq_from_obj(obj)
    return setmetatable(obj, TExportBiosFirmwareReq)
end

function TExportBiosFirmwareReq.new()
    return TExportBiosFirmwareReq_from_obj({})
end
---@param obj MBiosUpgradeService.ExportBiosFirmwareReq
function TExportBiosFirmwareReq:init_from_obj(obj)

end

function TExportBiosFirmwareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosFirmwareReq.group)
end

TExportBiosFirmwareReq.from_obj = TExportBiosFirmwareReq_from_obj

TExportBiosFirmwareReq.proto_property = {}

TExportBiosFirmwareReq.default = {}

TExportBiosFirmwareReq.struct = {}

function TExportBiosFirmwareReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TExportBiosFirmwareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosFirmwareReq.proto_property, errs, need_convert)
    return self
end

function TExportBiosFirmwareReq:unpack(_)
end

MBiosUpgradeService.ExportBiosFirmwareReq = TExportBiosFirmwareReq

return MBiosUpgradeService
