-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBiosFirmwareCustomConfig = {}

---@class MBiosFirmwareCustomConfig.CMSSignEnable
---@field CMSSignEnable boolean
local TCMSSignEnable = {}
TCMSSignEnable.__index = TCMSSignEnable
TCMSSignEnable.group = {}

local function TCMSSignEnable_from_obj(obj)
    return setmetatable(obj, TCMSSignEnable)
end

function TCMSSignEnable.new(CMSSignEnable)
    return TCMSSignEnable_from_obj({CMSSignEnable = CMSSignEnable == nil and true or CMSSignEnable})
end
---@param obj MBiosFirmwareCustomConfig.CMSSignEnable
function TCMSSignEnable:init_from_obj(obj)
    self.CMSSignEnable = obj.CMSSignEnable == nil and true or obj.CMSSignEnable
end

function TCMSSignEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCMSSignEnable.group)
end

TCMSSignEnable.from_obj = TCMSSignEnable_from_obj

TCMSSignEnable.proto_property = {'CMSSignEnable'}

TCMSSignEnable.default = {false}

TCMSSignEnable.struct = {{name = 'CMSSignEnable', is_array = false, struct = nil}}

function TCMSSignEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CMSSignEnable', self.CMSSignEnable, 'bool', false, errs, need_convert)

    TCMSSignEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCMSSignEnable.proto_property, errs, need_convert)
    return self
end

function TCMSSignEnable:unpack(_)
    return self.CMSSignEnable
end

MBiosFirmwareCustomConfig.CMSSignEnable = TCMSSignEnable

return MBiosFirmwareCustomConfig
