-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBiosConfigTable = {}

---@class MBiosConfigTable.FileNum
---@field FileNum integer
local TFileNum = {}
TFileNum.__index = TFileNum
TFileNum.group = {}

local function TFileNum_from_obj(obj)
    return setmetatable(obj, TFileNum)
end

function TFileNum.new(FileNum)
    return TFileNum_from_obj({FileNum = FileNum or 0})
end
---@param obj MBiosConfigTable.FileNum
function TFileNum:init_from_obj(obj)
    self.FileNum = obj.FileNum or 0
end

function TFileNum:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFileNum.group)
end

TFileNum.from_obj = TFileNum_from_obj

TFileNum.proto_property = {'FileNum'}

TFileNum.default = {0}

TFileNum.struct = {{name = 'FileNum', is_array = false, struct = nil}}

function TFileNum:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileNum', self.FileNum, 'uint8', false, errs, need_convert)

    TFileNum:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFileNum.proto_property, errs, need_convert)
    return self
end

function TFileNum:unpack(_)
    return self.FileNum
end

MBiosConfigTable.FileNum = TFileNum

---@class MBiosConfigTable.FileChannel
---@field FileChannel integer
local TFileChannel = {}
TFileChannel.__index = TFileChannel
TFileChannel.group = {}

local function TFileChannel_from_obj(obj)
    return setmetatable(obj, TFileChannel)
end

function TFileChannel.new(FileChannel)
    return TFileChannel_from_obj({FileChannel = FileChannel or 0})
end
---@param obj MBiosConfigTable.FileChannel
function TFileChannel:init_from_obj(obj)
    self.FileChannel = obj.FileChannel or 0
end

function TFileChannel:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFileChannel.group)
end

TFileChannel.from_obj = TFileChannel_from_obj

TFileChannel.proto_property = {'FileChannel'}

TFileChannel.default = {0}

TFileChannel.struct = {{name = 'FileChannel', is_array = false, struct = nil}}

function TFileChannel:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileChannel', self.FileChannel, 'uint8', false, errs, need_convert)

    TFileChannel:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFileChannel.proto_property, errs, need_convert)
    return self
end

function TFileChannel:unpack(_)
    return self.FileChannel
end

MBiosConfigTable.FileChannel = TFileChannel

---@class MBiosConfigTable.FileChangeFlag
---@field FileChangeFlag integer
local TFileChangeFlag = {}
TFileChangeFlag.__index = TFileChangeFlag
TFileChangeFlag.group = {}

local function TFileChangeFlag_from_obj(obj)
    return setmetatable(obj, TFileChangeFlag)
end

function TFileChangeFlag.new(FileChangeFlag)
    return TFileChangeFlag_from_obj({FileChangeFlag = FileChangeFlag or 0})
end
---@param obj MBiosConfigTable.FileChangeFlag
function TFileChangeFlag:init_from_obj(obj)
    self.FileChangeFlag = obj.FileChangeFlag or 0
end

function TFileChangeFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFileChangeFlag.group)
end

TFileChangeFlag.from_obj = TFileChangeFlag_from_obj

TFileChangeFlag.proto_property = {'FileChangeFlag'}

TFileChangeFlag.default = {0}

TFileChangeFlag.struct = {{name = 'FileChangeFlag', is_array = false, struct = nil}}

function TFileChangeFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileChangeFlag', self.FileChangeFlag, 'uint8', false, errs, need_convert)

    TFileChangeFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFileChangeFlag.proto_property, errs, need_convert)
    return self
end

function TFileChangeFlag:unpack(_)
    return self.FileChangeFlag
end

MBiosConfigTable.FileChangeFlag = TFileChangeFlag

---@class MBiosConfigTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MBiosConfigTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MBiosConfigTable.Id = TId

return MBiosConfigTable
