-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBiosBootOptionTable = {}

---@class MBiosBootOptionTable.WriteProtect
---@field WriteProtect string
local TWriteProtect = {}
TWriteProtect.__index = TWriteProtect
TWriteProtect.group = {}

local function TWriteProtect_from_obj(obj)
    return setmetatable(obj, TWriteProtect)
end

function TWriteProtect.new(WriteProtect)
    return TWriteProtect_from_obj({WriteProtect = WriteProtect})
end
---@param obj MBiosBootOptionTable.WriteProtect
function TWriteProtect:init_from_obj(obj)
    self.WriteProtect = obj.WriteProtect
end

function TWriteProtect:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteProtect.group)
end

TWriteProtect.from_obj = TWriteProtect_from_obj

TWriteProtect.proto_property = {'WriteProtect'}

TWriteProtect.default = {''}

TWriteProtect.struct = {{name = 'WriteProtect', is_array = false, struct = nil}}

function TWriteProtect:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WriteProtect', self.WriteProtect, 'string', false, errs, need_convert)

    TWriteProtect:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteProtect.proto_property, errs, need_convert)
    return self
end

function TWriteProtect:unpack(_)
    return self.WriteProtect
end

MBiosBootOptionTable.WriteProtect = TWriteProtect

---@class MBiosBootOptionTable.BootInitiatorMailbox
---@field BootInitiatorMailbox string
local TBootInitiatorMailbox = {}
TBootInitiatorMailbox.__index = TBootInitiatorMailbox
TBootInitiatorMailbox.group = {}

local function TBootInitiatorMailbox_from_obj(obj)
    return setmetatable(obj, TBootInitiatorMailbox)
end

function TBootInitiatorMailbox.new(BootInitiatorMailbox)
    return TBootInitiatorMailbox_from_obj({BootInitiatorMailbox = BootInitiatorMailbox})
end
---@param obj MBiosBootOptionTable.BootInitiatorMailbox
function TBootInitiatorMailbox:init_from_obj(obj)
    self.BootInitiatorMailbox = obj.BootInitiatorMailbox
end

function TBootInitiatorMailbox:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootInitiatorMailbox.group)
end

TBootInitiatorMailbox.from_obj = TBootInitiatorMailbox_from_obj

TBootInitiatorMailbox.proto_property = {'BootInitiatorMailbox'}

TBootInitiatorMailbox.default = {''}

TBootInitiatorMailbox.struct = {{name = 'BootInitiatorMailbox', is_array = false, struct = nil}}

function TBootInitiatorMailbox:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootInitiatorMailbox', self.BootInitiatorMailbox, 'string', false, errs, need_convert)

    TBootInitiatorMailbox:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootInitiatorMailbox.proto_property, errs, need_convert)
    return self
end

function TBootInitiatorMailbox:unpack(_)
    return self.BootInitiatorMailbox
end

MBiosBootOptionTable.BootInitiatorMailbox = TBootInitiatorMailbox

---@class MBiosBootOptionTable.BootInitiatorInfo
---@field BootInitiatorInfo string
local TBootInitiatorInfo = {}
TBootInitiatorInfo.__index = TBootInitiatorInfo
TBootInitiatorInfo.group = {}

local function TBootInitiatorInfo_from_obj(obj)
    return setmetatable(obj, TBootInitiatorInfo)
end

function TBootInitiatorInfo.new(BootInitiatorInfo)
    return TBootInitiatorInfo_from_obj({BootInitiatorInfo = BootInitiatorInfo})
end
---@param obj MBiosBootOptionTable.BootInitiatorInfo
function TBootInitiatorInfo:init_from_obj(obj)
    self.BootInitiatorInfo = obj.BootInitiatorInfo
end

function TBootInitiatorInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootInitiatorInfo.group)
end

TBootInitiatorInfo.from_obj = TBootInitiatorInfo_from_obj

TBootInitiatorInfo.proto_property = {'BootInitiatorInfo'}

TBootInitiatorInfo.default = {''}

TBootInitiatorInfo.struct = {{name = 'BootInitiatorInfo', is_array = false, struct = nil}}

function TBootInitiatorInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootInitiatorInfo', self.BootInitiatorInfo, 'string', false, errs, need_convert)

    TBootInitiatorInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootInitiatorInfo.proto_property, errs, need_convert)
    return self
end

function TBootInitiatorInfo:unpack(_)
    return self.BootInitiatorInfo
end

MBiosBootOptionTable.BootInitiatorInfo = TBootInitiatorInfo

---@class MBiosBootOptionTable.BootFlags
---@field BootFlags string
local TBootFlags = {}
TBootFlags.__index = TBootFlags
TBootFlags.group = {}

local function TBootFlags_from_obj(obj)
    return setmetatable(obj, TBootFlags)
end

function TBootFlags.new(BootFlags)
    return TBootFlags_from_obj({BootFlags = BootFlags})
end
---@param obj MBiosBootOptionTable.BootFlags
function TBootFlags:init_from_obj(obj)
    self.BootFlags = obj.BootFlags
end

function TBootFlags:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootFlags.group)
end

TBootFlags.from_obj = TBootFlags_from_obj

TBootFlags.proto_property = {'BootFlags'}

TBootFlags.default = {''}

TBootFlags.struct = {{name = 'BootFlags', is_array = false, struct = nil}}

function TBootFlags:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootFlags', self.BootFlags, 'string', false, errs, need_convert)

    TBootFlags:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootFlags.proto_property, errs, need_convert)
    return self
end

function TBootFlags:unpack(_)
    return self.BootFlags
end

MBiosBootOptionTable.BootFlags = TBootFlags

---@class MBiosBootOptionTable.BootInfoAcknowledge
---@field BootInfoAcknowledge string
local TBootInfoAcknowledge = {}
TBootInfoAcknowledge.__index = TBootInfoAcknowledge
TBootInfoAcknowledge.group = {}

local function TBootInfoAcknowledge_from_obj(obj)
    return setmetatable(obj, TBootInfoAcknowledge)
end

function TBootInfoAcknowledge.new(BootInfoAcknowledge)
    return TBootInfoAcknowledge_from_obj({BootInfoAcknowledge = BootInfoAcknowledge})
end
---@param obj MBiosBootOptionTable.BootInfoAcknowledge
function TBootInfoAcknowledge:init_from_obj(obj)
    self.BootInfoAcknowledge = obj.BootInfoAcknowledge
end

function TBootInfoAcknowledge:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootInfoAcknowledge.group)
end

TBootInfoAcknowledge.from_obj = TBootInfoAcknowledge_from_obj

TBootInfoAcknowledge.proto_property = {'BootInfoAcknowledge'}

TBootInfoAcknowledge.default = {''}

TBootInfoAcknowledge.struct = {{name = 'BootInfoAcknowledge', is_array = false, struct = nil}}

function TBootInfoAcknowledge:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootInfoAcknowledge', self.BootInfoAcknowledge, 'string', false, errs, need_convert)

    TBootInfoAcknowledge:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootInfoAcknowledge.proto_property, errs, need_convert)
    return self
end

function TBootInfoAcknowledge:unpack(_)
    return self.BootInfoAcknowledge
end

MBiosBootOptionTable.BootInfoAcknowledge = TBootInfoAcknowledge

---@class MBiosBootOptionTable.BootFlagValidBitClearing
---@field BootFlagValidBitClearing string
local TBootFlagValidBitClearing = {}
TBootFlagValidBitClearing.__index = TBootFlagValidBitClearing
TBootFlagValidBitClearing.group = {}

local function TBootFlagValidBitClearing_from_obj(obj)
    return setmetatable(obj, TBootFlagValidBitClearing)
end

function TBootFlagValidBitClearing.new(BootFlagValidBitClearing)
    return TBootFlagValidBitClearing_from_obj({BootFlagValidBitClearing = BootFlagValidBitClearing})
end
---@param obj MBiosBootOptionTable.BootFlagValidBitClearing
function TBootFlagValidBitClearing:init_from_obj(obj)
    self.BootFlagValidBitClearing = obj.BootFlagValidBitClearing
end

function TBootFlagValidBitClearing:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBootFlagValidBitClearing.group)
end

TBootFlagValidBitClearing.from_obj = TBootFlagValidBitClearing_from_obj

TBootFlagValidBitClearing.proto_property = {'BootFlagValidBitClearing'}

TBootFlagValidBitClearing.default = {''}

TBootFlagValidBitClearing.struct = {{name = 'BootFlagValidBitClearing', is_array = false, struct = nil}}

function TBootFlagValidBitClearing:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootFlagValidBitClearing', self.BootFlagValidBitClearing, 'string', false, errs,
        need_convert)

    TBootFlagValidBitClearing:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBootFlagValidBitClearing.proto_property, errs, need_convert)
    return self
end

function TBootFlagValidBitClearing:unpack(_)
    return self.BootFlagValidBitClearing
end

MBiosBootOptionTable.BootFlagValidBitClearing = TBootFlagValidBitClearing

---@class MBiosBootOptionTable.ServicePartitionScan
---@field ServicePartitionScan string
local TServicePartitionScan = {}
TServicePartitionScan.__index = TServicePartitionScan
TServicePartitionScan.group = {}

local function TServicePartitionScan_from_obj(obj)
    return setmetatable(obj, TServicePartitionScan)
end

function TServicePartitionScan.new(ServicePartitionScan)
    return TServicePartitionScan_from_obj({ServicePartitionScan = ServicePartitionScan})
end
---@param obj MBiosBootOptionTable.ServicePartitionScan
function TServicePartitionScan:init_from_obj(obj)
    self.ServicePartitionScan = obj.ServicePartitionScan
end

function TServicePartitionScan:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TServicePartitionScan.group)
end

TServicePartitionScan.from_obj = TServicePartitionScan_from_obj

TServicePartitionScan.proto_property = {'ServicePartitionScan'}

TServicePartitionScan.default = {''}

TServicePartitionScan.struct = {{name = 'ServicePartitionScan', is_array = false, struct = nil}}

function TServicePartitionScan:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ServicePartitionScan', self.ServicePartitionScan, 'string', false, errs, need_convert)

    TServicePartitionScan:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TServicePartitionScan.proto_property, errs, need_convert)
    return self
end

function TServicePartitionScan:unpack(_)
    return self.ServicePartitionScan
end

MBiosBootOptionTable.ServicePartitionScan = TServicePartitionScan

---@class MBiosBootOptionTable.ServicePartitionSelector
---@field ServicePartitionSelector string
local TServicePartitionSelector = {}
TServicePartitionSelector.__index = TServicePartitionSelector
TServicePartitionSelector.group = {}

local function TServicePartitionSelector_from_obj(obj)
    return setmetatable(obj, TServicePartitionSelector)
end

function TServicePartitionSelector.new(ServicePartitionSelector)
    return TServicePartitionSelector_from_obj({ServicePartitionSelector = ServicePartitionSelector})
end
---@param obj MBiosBootOptionTable.ServicePartitionSelector
function TServicePartitionSelector:init_from_obj(obj)
    self.ServicePartitionSelector = obj.ServicePartitionSelector
end

function TServicePartitionSelector:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TServicePartitionSelector.group)
end

TServicePartitionSelector.from_obj = TServicePartitionSelector_from_obj

TServicePartitionSelector.proto_property = {'ServicePartitionSelector'}

TServicePartitionSelector.default = {''}

TServicePartitionSelector.struct = {{name = 'ServicePartitionSelector', is_array = false, struct = nil}}

function TServicePartitionSelector:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ServicePartitionSelector', self.ServicePartitionSelector, 'string', false, errs,
        need_convert)

    TServicePartitionSelector:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TServicePartitionSelector.proto_property, errs, need_convert)
    return self
end

function TServicePartitionSelector:unpack(_)
    return self.ServicePartitionSelector
end

MBiosBootOptionTable.ServicePartitionSelector = TServicePartitionSelector

---@class MBiosBootOptionTable.SetInProgress
---@field SetInProgress string
local TSetInProgress = {}
TSetInProgress.__index = TSetInProgress
TSetInProgress.group = {}

local function TSetInProgress_from_obj(obj)
    return setmetatable(obj, TSetInProgress)
end

function TSetInProgress.new(SetInProgress)
    return TSetInProgress_from_obj({SetInProgress = SetInProgress})
end
---@param obj MBiosBootOptionTable.SetInProgress
function TSetInProgress:init_from_obj(obj)
    self.SetInProgress = obj.SetInProgress
end

function TSetInProgress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetInProgress.group)
end

TSetInProgress.from_obj = TSetInProgress_from_obj

TSetInProgress.proto_property = {'SetInProgress'}

TSetInProgress.default = {''}

TSetInProgress.struct = {{name = 'SetInProgress', is_array = false, struct = nil}}

function TSetInProgress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SetInProgress', self.SetInProgress, 'string', false, errs, need_convert)

    TSetInProgress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetInProgress.proto_property, errs, need_convert)
    return self
end

function TSetInProgress:unpack(_)
    return self.SetInProgress
end

MBiosBootOptionTable.SetInProgress = TSetInProgress

---@class MBiosBootOptionTable.ValidFlag
---@field ValidFlag string
local TValidFlag = {}
TValidFlag.__index = TValidFlag
TValidFlag.group = {}

local function TValidFlag_from_obj(obj)
    return setmetatable(obj, TValidFlag)
end

function TValidFlag.new(ValidFlag)
    return TValidFlag_from_obj({ValidFlag = ValidFlag})
end
---@param obj MBiosBootOptionTable.ValidFlag
function TValidFlag:init_from_obj(obj)
    self.ValidFlag = obj.ValidFlag
end

function TValidFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TValidFlag.group)
end

TValidFlag.from_obj = TValidFlag_from_obj

TValidFlag.proto_property = {'ValidFlag'}

TValidFlag.default = {''}

TValidFlag.struct = {{name = 'ValidFlag', is_array = false, struct = nil}}

function TValidFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ValidFlag', self.ValidFlag, 'string', false, errs, need_convert)

    TValidFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TValidFlag.proto_property, errs, need_convert)
    return self
end

function TValidFlag:unpack(_)
    return self.ValidFlag
end

MBiosBootOptionTable.ValidFlag = TValidFlag

---@class MBiosBootOptionTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MBiosBootOptionTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MBiosBootOptionTable.Id = TId

return MBiosBootOptionTable
