-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MBios = {}

---@class MBios.Soc
---@field Soc string
local TSoc = {}
TSoc.__index = TSoc
TSoc.group = {}

local function TSoc_from_obj(obj)
    return setmetatable(obj, TSoc)
end

function TSoc.new(Soc)
    return TSoc_from_obj({Soc = Soc})
end
---@param obj MBios.Soc
function TSoc:init_from_obj(obj)
    self.Soc = obj.Soc
end

function TSoc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSoc.group)
end

TSoc.from_obj = TSoc_from_obj

TSoc.proto_property = {'Soc'}

TSoc.default = {''}

TSoc.struct = {{name = 'Soc', is_array = false, struct = nil}}

function TSoc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Soc', self.Soc, 'string', false, errs, need_convert)

    TSoc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSoc.proto_property, errs, need_convert)
    return self
end

function TSoc:unpack(_)
    return self.Soc
end

MBios.Soc = TSoc

---@class MBios.SecureBootVerifyState
---@field SecureBootVerifyState integer
local TSecureBootVerifyState = {}
TSecureBootVerifyState.__index = TSecureBootVerifyState
TSecureBootVerifyState.group = {}

local function TSecureBootVerifyState_from_obj(obj)
    return setmetatable(obj, TSecureBootVerifyState)
end

function TSecureBootVerifyState.new(SecureBootVerifyState)
    return TSecureBootVerifyState_from_obj({SecureBootVerifyState = SecureBootVerifyState})
end
---@param obj MBios.SecureBootVerifyState
function TSecureBootVerifyState:init_from_obj(obj)
    self.SecureBootVerifyState = obj.SecureBootVerifyState
end

function TSecureBootVerifyState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSecureBootVerifyState.group)
end

TSecureBootVerifyState.from_obj = TSecureBootVerifyState_from_obj

TSecureBootVerifyState.proto_property = {'SecureBootVerifyState'}

TSecureBootVerifyState.default = {0}

TSecureBootVerifyState.struct = {{name = 'SecureBootVerifyState', is_array = false, struct = nil}}

function TSecureBootVerifyState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SecureBootVerifyState', self.SecureBootVerifyState, 'uint8', false, errs, need_convert)

    TSecureBootVerifyState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSecureBootVerifyState.proto_property, errs, need_convert)
    return self
end

function TSecureBootVerifyState:unpack(_)
    return self.SecureBootVerifyState
end

MBios.SecureBootVerifyState = TSecureBootVerifyState

---@class MBios.SecureBootVerifyCompletionCode
---@field SecureBootVerifyCompletionCode integer
local TSecureBootVerifyCompletionCode = {}
TSecureBootVerifyCompletionCode.__index = TSecureBootVerifyCompletionCode
TSecureBootVerifyCompletionCode.group = {}

local function TSecureBootVerifyCompletionCode_from_obj(obj)
    return setmetatable(obj, TSecureBootVerifyCompletionCode)
end

function TSecureBootVerifyCompletionCode.new(SecureBootVerifyCompletionCode)
    return TSecureBootVerifyCompletionCode_from_obj({SecureBootVerifyCompletionCode = SecureBootVerifyCompletionCode})
end
---@param obj MBios.SecureBootVerifyCompletionCode
function TSecureBootVerifyCompletionCode:init_from_obj(obj)
    self.SecureBootVerifyCompletionCode = obj.SecureBootVerifyCompletionCode
end

function TSecureBootVerifyCompletionCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSecureBootVerifyCompletionCode.group)
end

TSecureBootVerifyCompletionCode.from_obj = TSecureBootVerifyCompletionCode_from_obj

TSecureBootVerifyCompletionCode.proto_property = {'SecureBootVerifyCompletionCode'}

TSecureBootVerifyCompletionCode.default = {0}

TSecureBootVerifyCompletionCode.struct = {{name = 'SecureBootVerifyCompletionCode', is_array = false, struct = nil}}

function TSecureBootVerifyCompletionCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SecureBootVerifyCompletionCode', self.SecureBootVerifyCompletionCode, 'uint8', false,
        errs, need_convert)

    TSecureBootVerifyCompletionCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSecureBootVerifyCompletionCode.proto_property, errs, need_convert)
    return self
end

function TSecureBootVerifyCompletionCode:unpack(_)
    return self.SecureBootVerifyCompletionCode
end

MBios.SecureBootVerifyCompletionCode = TSecureBootVerifyCompletionCode

---@class MBios.SecureBootEnableState
---@field SecureBootEnableState integer
local TSecureBootEnableState = {}
TSecureBootEnableState.__index = TSecureBootEnableState
TSecureBootEnableState.group = {}

local function TSecureBootEnableState_from_obj(obj)
    return setmetatable(obj, TSecureBootEnableState)
end

function TSecureBootEnableState.new(SecureBootEnableState)
    return TSecureBootEnableState_from_obj({SecureBootEnableState = SecureBootEnableState})
end
---@param obj MBios.SecureBootEnableState
function TSecureBootEnableState:init_from_obj(obj)
    self.SecureBootEnableState = obj.SecureBootEnableState
end

function TSecureBootEnableState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSecureBootEnableState.group)
end

TSecureBootEnableState.from_obj = TSecureBootEnableState_from_obj

TSecureBootEnableState.proto_property = {'SecureBootEnableState'}

TSecureBootEnableState.default = {0}

TSecureBootEnableState.struct = {{name = 'SecureBootEnableState', is_array = false, struct = nil}}

function TSecureBootEnableState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SecureBootEnableState', self.SecureBootEnableState, 'uint8', false, errs, need_convert)

    TSecureBootEnableState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSecureBootEnableState.proto_property, errs, need_convert)
    return self
end

function TSecureBootEnableState:unpack(_)
    return self.SecureBootEnableState
end

MBios.SecureBootEnableState = TSecureBootEnableState

---@class MBios.SecureBootEnableCompletionCode
---@field SecureBootEnableCompletionCode integer
local TSecureBootEnableCompletionCode = {}
TSecureBootEnableCompletionCode.__index = TSecureBootEnableCompletionCode
TSecureBootEnableCompletionCode.group = {}

local function TSecureBootEnableCompletionCode_from_obj(obj)
    return setmetatable(obj, TSecureBootEnableCompletionCode)
end

function TSecureBootEnableCompletionCode.new(SecureBootEnableCompletionCode)
    return TSecureBootEnableCompletionCode_from_obj({SecureBootEnableCompletionCode = SecureBootEnableCompletionCode})
end
---@param obj MBios.SecureBootEnableCompletionCode
function TSecureBootEnableCompletionCode:init_from_obj(obj)
    self.SecureBootEnableCompletionCode = obj.SecureBootEnableCompletionCode
end

function TSecureBootEnableCompletionCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSecureBootEnableCompletionCode.group)
end

TSecureBootEnableCompletionCode.from_obj = TSecureBootEnableCompletionCode_from_obj

TSecureBootEnableCompletionCode.proto_property = {'SecureBootEnableCompletionCode'}

TSecureBootEnableCompletionCode.default = {0}

TSecureBootEnableCompletionCode.struct = {{name = 'SecureBootEnableCompletionCode', is_array = false, struct = nil}}

function TSecureBootEnableCompletionCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SecureBootEnableCompletionCode', self.SecureBootEnableCompletionCode, 'uint8', false,
        errs, need_convert)

    TSecureBootEnableCompletionCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSecureBootEnableCompletionCode.proto_property, errs, need_convert)
    return self
end

function TSecureBootEnableCompletionCode:unpack(_)
    return self.SecureBootEnableCompletionCode
end

MBios.SecureBootEnableCompletionCode = TSecureBootEnableCompletionCode

---@class MBios.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj MBios.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

MBios.Slot = TSlot

---@class MBios.ResetCmos
---@field ResetCmos integer
local TResetCmos = {}
TResetCmos.__index = TResetCmos
TResetCmos.group = {}

local function TResetCmos_from_obj(obj)
    return setmetatable(obj, TResetCmos)
end

function TResetCmos.new(ResetCmos)
    return TResetCmos_from_obj({ResetCmos = ResetCmos})
end
---@param obj MBios.ResetCmos
function TResetCmos:init_from_obj(obj)
    self.ResetCmos = obj.ResetCmos
end

function TResetCmos:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetCmos.group)
end

TResetCmos.from_obj = TResetCmos_from_obj

TResetCmos.proto_property = {'ResetCmos'}

TResetCmos.default = {0}

TResetCmos.struct = {{name = 'ResetCmos', is_array = false, struct = nil}}

function TResetCmos:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetCmos', self.ResetCmos, 'uint8', false, errs, need_convert)

    TResetCmos:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetCmos.proto_property, errs, need_convert)
    return self
end

function TResetCmos:unpack(_)
    return self.ResetCmos
end

MBios.ResetCmos = TResetCmos

return MBios
