-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MAllowedBiosUpgradeTable = {}

---@class MAllowedBiosUpgradeTable.AllowedPackageType
---@field AllowedPackageType integer
local TAllowedPackageType = {}
TAllowedPackageType.__index = TAllowedPackageType
TAllowedPackageType.group = {}

local function TAllowedPackageType_from_obj(obj)
    return setmetatable(obj, TAllowedPackageType)
end

function TAllowedPackageType.new(AllowedPackageType)
    return TAllowedPackageType_from_obj({AllowedPackageType = AllowedPackageType})
end
---@param obj MAllowedBiosUpgradeTable.AllowedPackageType
function TAllowedPackageType:init_from_obj(obj)
    self.AllowedPackageType = obj.AllowedPackageType
end

function TAllowedPackageType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAllowedPackageType.group)
end

TAllowedPackageType.from_obj = TAllowedPackageType_from_obj

TAllowedPackageType.proto_property = {'AllowedPackageType'}

TAllowedPackageType.default = {0}

TAllowedPackageType.struct = {{name = 'AllowedPackageType', is_array = false, struct = nil}}

function TAllowedPackageType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AllowedPackageType', self.AllowedPackageType, 'uint8', false, errs, need_convert)

    TAllowedPackageType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAllowedPackageType.proto_property, errs, need_convert)
    return self
end

function TAllowedPackageType:unpack(_)
    return self.AllowedPackageType
end

MAllowedBiosUpgradeTable.AllowedPackageType = TAllowedPackageType

---@class MAllowedBiosUpgradeTable.PackageStatus
---@field PackageStatus integer
local TPackageStatus = {}
TPackageStatus.__index = TPackageStatus
TPackageStatus.group = {}

local function TPackageStatus_from_obj(obj)
    return setmetatable(obj, TPackageStatus)
end

function TPackageStatus.new(PackageStatus)
    return TPackageStatus_from_obj({PackageStatus = PackageStatus or 0})
end
---@param obj MAllowedBiosUpgradeTable.PackageStatus
function TPackageStatus:init_from_obj(obj)
    self.PackageStatus = obj.PackageStatus or 0
end

function TPackageStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPackageStatus.group)
end

TPackageStatus.from_obj = TPackageStatus_from_obj

TPackageStatus.proto_property = {'PackageStatus'}

TPackageStatus.default = {0}

TPackageStatus.struct = {{name = 'PackageStatus', is_array = false, struct = nil}}

function TPackageStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PackageStatus', self.PackageStatus, 'uint8', false, errs, need_convert)

    TPackageStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPackageStatus.proto_property, errs, need_convert)
    return self
end

function TPackageStatus:unpack(_)
    return self.PackageStatus
end

MAllowedBiosUpgradeTable.PackageStatus = TPackageStatus

---@class MAllowedBiosUpgradeTable.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id or 1})
end
---@param obj MAllowedBiosUpgradeTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id or 1
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MAllowedBiosUpgradeTable.Id = TId

return MAllowedBiosUpgradeTable
