-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Watchdog2Status = {}

---@class Watchdog2Status.ExpirationEventData
---@field ExpirationEventData integer
local TExpirationEventData = {}
TExpirationEventData.__index = TExpirationEventData
TExpirationEventData.group = {}

local function TExpirationEventData_from_obj(obj)
    return setmetatable(obj, TExpirationEventData)
end

function TExpirationEventData.new(ExpirationEventData)
    return TExpirationEventData_from_obj({ExpirationEventData = ExpirationEventData})
end
---@param obj Watchdog2Status.ExpirationEventData
function TExpirationEventData:init_from_obj(obj)
    self.ExpirationEventData = obj.ExpirationEventData
end

function TExpirationEventData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExpirationEventData.group)
end

TExpirationEventData.from_obj = TExpirationEventData_from_obj

TExpirationEventData.proto_property = {'ExpirationEventData'}

TExpirationEventData.default = {0}

TExpirationEventData.struct = {{name = 'ExpirationEventData', is_array = false, struct = nil}}

function TExpirationEventData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExpirationEventData', self.ExpirationEventData, 'uint32', true, errs, need_convert)

    TExpirationEventData:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExpirationEventData.proto_property, errs, need_convert)
    return self
end

function TExpirationEventData:unpack(_)
    return self.ExpirationEventData
end

Watchdog2Status.ExpirationEventData = TExpirationEventData

---@class Watchdog2Status.BIOSFailToStartFlag
---@field BIOSFailToStartFlag integer
local TBIOSFailToStartFlag = {}
TBIOSFailToStartFlag.__index = TBIOSFailToStartFlag
TBIOSFailToStartFlag.group = {}

local function TBIOSFailToStartFlag_from_obj(obj)
    return setmetatable(obj, TBIOSFailToStartFlag)
end

function TBIOSFailToStartFlag.new(BIOSFailToStartFlag)
    return TBIOSFailToStartFlag_from_obj({BIOSFailToStartFlag = BIOSFailToStartFlag})
end
---@param obj Watchdog2Status.BIOSFailToStartFlag
function TBIOSFailToStartFlag:init_from_obj(obj)
    self.BIOSFailToStartFlag = obj.BIOSFailToStartFlag
end

function TBIOSFailToStartFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBIOSFailToStartFlag.group)
end

TBIOSFailToStartFlag.from_obj = TBIOSFailToStartFlag_from_obj

TBIOSFailToStartFlag.proto_property = {'BIOSFailToStartFlag'}

TBIOSFailToStartFlag.default = {0}

TBIOSFailToStartFlag.struct = {{name = 'BIOSFailToStartFlag', is_array = false, struct = nil}}

function TBIOSFailToStartFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BIOSFailToStartFlag', self.BIOSFailToStartFlag, 'uint8', true, errs, need_convert)

    TBIOSFailToStartFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBIOSFailToStartFlag.proto_property, errs, need_convert)
    return self
end

function TBIOSFailToStartFlag:unpack(_)
    return self.BIOSFailToStartFlag
end

Watchdog2Status.BIOSFailToStartFlag = TBIOSFailToStartFlag

---@class Watchdog2Status.PresentCountdown
---@field PresentCountdown integer
local TPresentCountdown = {}
TPresentCountdown.__index = TPresentCountdown
TPresentCountdown.group = {}

local function TPresentCountdown_from_obj(obj)
    return setmetatable(obj, TPresentCountdown)
end

function TPresentCountdown.new(PresentCountdown)
    return TPresentCountdown_from_obj({PresentCountdown = PresentCountdown})
end
---@param obj Watchdog2Status.PresentCountdown
function TPresentCountdown:init_from_obj(obj)
    self.PresentCountdown = obj.PresentCountdown
end

function TPresentCountdown:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresentCountdown.group)
end

TPresentCountdown.from_obj = TPresentCountdown_from_obj

TPresentCountdown.proto_property = {'PresentCountdown'}

TPresentCountdown.default = {0}

TPresentCountdown.struct = {{name = 'PresentCountdown', is_array = false, struct = nil}}

function TPresentCountdown:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PresentCountdown', self.PresentCountdown, 'uint16', true, errs, need_convert)

    TPresentCountdown:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresentCountdown.proto_property, errs, need_convert)
    return self
end

function TPresentCountdown:unpack(_)
    return self.PresentCountdown
end

Watchdog2Status.PresentCountdown = TPresentCountdown

---@class Watchdog2Status.InitialCountdown
---@field InitialCountdown integer
local TInitialCountdown = {}
TInitialCountdown.__index = TInitialCountdown
TInitialCountdown.group = {}

local function TInitialCountdown_from_obj(obj)
    return setmetatable(obj, TInitialCountdown)
end

function TInitialCountdown.new(InitialCountdown)
    return TInitialCountdown_from_obj({InitialCountdown = InitialCountdown})
end
---@param obj Watchdog2Status.InitialCountdown
function TInitialCountdown:init_from_obj(obj)
    self.InitialCountdown = obj.InitialCountdown
end

function TInitialCountdown:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInitialCountdown.group)
end

TInitialCountdown.from_obj = TInitialCountdown_from_obj

TInitialCountdown.proto_property = {'InitialCountdown'}

TInitialCountdown.default = {0}

TInitialCountdown.struct = {{name = 'InitialCountdown', is_array = false, struct = nil}}

function TInitialCountdown:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InitialCountdown', self.InitialCountdown, 'uint16', true, errs, need_convert)

    TInitialCountdown:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInitialCountdown.proto_property, errs, need_convert)
    return self
end

function TInitialCountdown:unpack(_)
    return self.InitialCountdown
end

Watchdog2Status.InitialCountdown = TInitialCountdown

---@class Watchdog2Status.BIOSFRB2ExpirationFlag
---@field BIOSFRB2ExpirationFlag integer
local TBIOSFRB2ExpirationFlag = {}
TBIOSFRB2ExpirationFlag.__index = TBIOSFRB2ExpirationFlag
TBIOSFRB2ExpirationFlag.group = {}

local function TBIOSFRB2ExpirationFlag_from_obj(obj)
    return setmetatable(obj, TBIOSFRB2ExpirationFlag)
end

function TBIOSFRB2ExpirationFlag.new(BIOSFRB2ExpirationFlag)
    return TBIOSFRB2ExpirationFlag_from_obj({BIOSFRB2ExpirationFlag = BIOSFRB2ExpirationFlag})
end
---@param obj Watchdog2Status.BIOSFRB2ExpirationFlag
function TBIOSFRB2ExpirationFlag:init_from_obj(obj)
    self.BIOSFRB2ExpirationFlag = obj.BIOSFRB2ExpirationFlag
end

function TBIOSFRB2ExpirationFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBIOSFRB2ExpirationFlag.group)
end

TBIOSFRB2ExpirationFlag.from_obj = TBIOSFRB2ExpirationFlag_from_obj

TBIOSFRB2ExpirationFlag.proto_property = {'BIOSFRB2ExpirationFlag'}

TBIOSFRB2ExpirationFlag.default = {0}

TBIOSFRB2ExpirationFlag.struct = {{name = 'BIOSFRB2ExpirationFlag', is_array = false, struct = nil}}

function TBIOSFRB2ExpirationFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BIOSFRB2ExpirationFlag', self.BIOSFRB2ExpirationFlag, 'uint8', true, errs, need_convert)

    TBIOSFRB2ExpirationFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBIOSFRB2ExpirationFlag.proto_property, errs, need_convert)
    return self
end

function TBIOSFRB2ExpirationFlag:unpack(_)
    return self.BIOSFRB2ExpirationFlag
end

Watchdog2Status.BIOSFRB2ExpirationFlag = TBIOSFRB2ExpirationFlag

---@class Watchdog2Status.BIOSPOSTExpirationFlag
---@field BIOSPOSTExpirationFlag integer
local TBIOSPOSTExpirationFlag = {}
TBIOSPOSTExpirationFlag.__index = TBIOSPOSTExpirationFlag
TBIOSPOSTExpirationFlag.group = {}

local function TBIOSPOSTExpirationFlag_from_obj(obj)
    return setmetatable(obj, TBIOSPOSTExpirationFlag)
end

function TBIOSPOSTExpirationFlag.new(BIOSPOSTExpirationFlag)
    return TBIOSPOSTExpirationFlag_from_obj({BIOSPOSTExpirationFlag = BIOSPOSTExpirationFlag})
end
---@param obj Watchdog2Status.BIOSPOSTExpirationFlag
function TBIOSPOSTExpirationFlag:init_from_obj(obj)
    self.BIOSPOSTExpirationFlag = obj.BIOSPOSTExpirationFlag
end

function TBIOSPOSTExpirationFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBIOSPOSTExpirationFlag.group)
end

TBIOSPOSTExpirationFlag.from_obj = TBIOSPOSTExpirationFlag_from_obj

TBIOSPOSTExpirationFlag.proto_property = {'BIOSPOSTExpirationFlag'}

TBIOSPOSTExpirationFlag.default = {0}

TBIOSPOSTExpirationFlag.struct = {{name = 'BIOSPOSTExpirationFlag', is_array = false, struct = nil}}

function TBIOSPOSTExpirationFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BIOSPOSTExpirationFlag', self.BIOSPOSTExpirationFlag, 'uint8', true, errs, need_convert)

    TBIOSPOSTExpirationFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBIOSPOSTExpirationFlag.proto_property, errs, need_convert)
    return self
end

function TBIOSPOSTExpirationFlag:unpack(_)
    return self.BIOSPOSTExpirationFlag
end

Watchdog2Status.BIOSPOSTExpirationFlag = TBIOSPOSTExpirationFlag

---@class Watchdog2Status.OSLoadExpirationFlag
---@field OSLoadExpirationFlag integer
local TOSLoadExpirationFlag = {}
TOSLoadExpirationFlag.__index = TOSLoadExpirationFlag
TOSLoadExpirationFlag.group = {}

local function TOSLoadExpirationFlag_from_obj(obj)
    return setmetatable(obj, TOSLoadExpirationFlag)
end

function TOSLoadExpirationFlag.new(OSLoadExpirationFlag)
    return TOSLoadExpirationFlag_from_obj({OSLoadExpirationFlag = OSLoadExpirationFlag})
end
---@param obj Watchdog2Status.OSLoadExpirationFlag
function TOSLoadExpirationFlag:init_from_obj(obj)
    self.OSLoadExpirationFlag = obj.OSLoadExpirationFlag
end

function TOSLoadExpirationFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOSLoadExpirationFlag.group)
end

TOSLoadExpirationFlag.from_obj = TOSLoadExpirationFlag_from_obj

TOSLoadExpirationFlag.proto_property = {'OSLoadExpirationFlag'}

TOSLoadExpirationFlag.default = {0}

TOSLoadExpirationFlag.struct = {{name = 'OSLoadExpirationFlag', is_array = false, struct = nil}}

function TOSLoadExpirationFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OSLoadExpirationFlag', self.OSLoadExpirationFlag, 'uint8', true, errs, need_convert)

    TOSLoadExpirationFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOSLoadExpirationFlag.proto_property, errs, need_convert)
    return self
end

function TOSLoadExpirationFlag:unpack(_)
    return self.OSLoadExpirationFlag
end

Watchdog2Status.OSLoadExpirationFlag = TOSLoadExpirationFlag

---@class Watchdog2Status.SMSExpirationFlag
---@field SMSExpirationFlag integer
local TSMSExpirationFlag = {}
TSMSExpirationFlag.__index = TSMSExpirationFlag
TSMSExpirationFlag.group = {}

local function TSMSExpirationFlag_from_obj(obj)
    return setmetatable(obj, TSMSExpirationFlag)
end

function TSMSExpirationFlag.new(SMSExpirationFlag)
    return TSMSExpirationFlag_from_obj({SMSExpirationFlag = SMSExpirationFlag})
end
---@param obj Watchdog2Status.SMSExpirationFlag
function TSMSExpirationFlag:init_from_obj(obj)
    self.SMSExpirationFlag = obj.SMSExpirationFlag
end

function TSMSExpirationFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSMSExpirationFlag.group)
end

TSMSExpirationFlag.from_obj = TSMSExpirationFlag_from_obj

TSMSExpirationFlag.proto_property = {'SMSExpirationFlag'}

TSMSExpirationFlag.default = {0}

TSMSExpirationFlag.struct = {{name = 'SMSExpirationFlag', is_array = false, struct = nil}}

function TSMSExpirationFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SMSExpirationFlag', self.SMSExpirationFlag, 'uint8', true, errs, need_convert)

    TSMSExpirationFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSMSExpirationFlag.proto_property, errs, need_convert)
    return self
end

function TSMSExpirationFlag:unpack(_)
    return self.SMSExpirationFlag
end

Watchdog2Status.SMSExpirationFlag = TSMSExpirationFlag

---@class Watchdog2Status.OEMExpirationFlag
---@field OEMExpirationFlag integer
local TOEMExpirationFlag = {}
TOEMExpirationFlag.__index = TOEMExpirationFlag
TOEMExpirationFlag.group = {}

local function TOEMExpirationFlag_from_obj(obj)
    return setmetatable(obj, TOEMExpirationFlag)
end

function TOEMExpirationFlag.new(OEMExpirationFlag)
    return TOEMExpirationFlag_from_obj({OEMExpirationFlag = OEMExpirationFlag})
end
---@param obj Watchdog2Status.OEMExpirationFlag
function TOEMExpirationFlag:init_from_obj(obj)
    self.OEMExpirationFlag = obj.OEMExpirationFlag
end

function TOEMExpirationFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOEMExpirationFlag.group)
end

TOEMExpirationFlag.from_obj = TOEMExpirationFlag_from_obj

TOEMExpirationFlag.proto_property = {'OEMExpirationFlag'}

TOEMExpirationFlag.default = {0}

TOEMExpirationFlag.struct = {{name = 'OEMExpirationFlag', is_array = false, struct = nil}}

function TOEMExpirationFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OEMExpirationFlag', self.OEMExpirationFlag, 'uint8', true, errs, need_convert)

    TOEMExpirationFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOEMExpirationFlag.proto_property, errs, need_convert)
    return self
end

function TOEMExpirationFlag:unpack(_)
    return self.OEMExpirationFlag
end

Watchdog2Status.OEMExpirationFlag = TOEMExpirationFlag

---@class Watchdog2Status.TimeoutAction
---@field TimeoutAction integer
local TTimeoutAction = {}
TTimeoutAction.__index = TTimeoutAction
TTimeoutAction.group = {}

local function TTimeoutAction_from_obj(obj)
    return setmetatable(obj, TTimeoutAction)
end

function TTimeoutAction.new(TimeoutAction)
    return TTimeoutAction_from_obj({TimeoutAction = TimeoutAction})
end
---@param obj Watchdog2Status.TimeoutAction
function TTimeoutAction:init_from_obj(obj)
    self.TimeoutAction = obj.TimeoutAction
end

function TTimeoutAction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeoutAction.group)
end

TTimeoutAction.from_obj = TTimeoutAction_from_obj

TTimeoutAction.proto_property = {'TimeoutAction'}

TTimeoutAction.default = {0}

TTimeoutAction.struct = {{name = 'TimeoutAction', is_array = false, struct = nil}}

function TTimeoutAction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeoutAction', self.TimeoutAction, 'uint8', true, errs, need_convert)

    TTimeoutAction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeoutAction.proto_property, errs, need_convert)
    return self
end

function TTimeoutAction:unpack(_)
    return self.TimeoutAction
end

Watchdog2Status.TimeoutAction = TTimeoutAction

---@class Watchdog2Status.PreTimeoutInterruptInterval
---@field PreTimeoutInterruptInterval integer
local TPreTimeoutInterruptInterval = {}
TPreTimeoutInterruptInterval.__index = TPreTimeoutInterruptInterval
TPreTimeoutInterruptInterval.group = {}

local function TPreTimeoutInterruptInterval_from_obj(obj)
    return setmetatable(obj, TPreTimeoutInterruptInterval)
end

function TPreTimeoutInterruptInterval.new(PreTimeoutInterruptInterval)
    return TPreTimeoutInterruptInterval_from_obj({PreTimeoutInterruptInterval = PreTimeoutInterruptInterval})
end
---@param obj Watchdog2Status.PreTimeoutInterruptInterval
function TPreTimeoutInterruptInterval:init_from_obj(obj)
    self.PreTimeoutInterruptInterval = obj.PreTimeoutInterruptInterval
end

function TPreTimeoutInterruptInterval:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreTimeoutInterruptInterval.group)
end

TPreTimeoutInterruptInterval.from_obj = TPreTimeoutInterruptInterval_from_obj

TPreTimeoutInterruptInterval.proto_property = {'PreTimeoutInterruptInterval'}

TPreTimeoutInterruptInterval.default = {0}

TPreTimeoutInterruptInterval.struct = {{name = 'PreTimeoutInterruptInterval', is_array = false, struct = nil}}

function TPreTimeoutInterruptInterval:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreTimeoutInterruptInterval', self.PreTimeoutInterruptInterval, 'uint8', true, errs,
        need_convert)

    TPreTimeoutInterruptInterval:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreTimeoutInterruptInterval.proto_property, errs, need_convert)
    return self
end

function TPreTimeoutInterruptInterval:unpack(_)
    return self.PreTimeoutInterruptInterval
end

Watchdog2Status.PreTimeoutInterruptInterval = TPreTimeoutInterruptInterval

---@class Watchdog2Status.PreTimeoutInterruptEnabled
---@field PreTimeoutInterruptEnabled boolean
local TPreTimeoutInterruptEnabled = {}
TPreTimeoutInterruptEnabled.__index = TPreTimeoutInterruptEnabled
TPreTimeoutInterruptEnabled.group = {}

local function TPreTimeoutInterruptEnabled_from_obj(obj)
    return setmetatable(obj, TPreTimeoutInterruptEnabled)
end

function TPreTimeoutInterruptEnabled.new(PreTimeoutInterruptEnabled)
    return TPreTimeoutInterruptEnabled_from_obj({PreTimeoutInterruptEnabled = PreTimeoutInterruptEnabled})
end
---@param obj Watchdog2Status.PreTimeoutInterruptEnabled
function TPreTimeoutInterruptEnabled:init_from_obj(obj)
    self.PreTimeoutInterruptEnabled = obj.PreTimeoutInterruptEnabled
end

function TPreTimeoutInterruptEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreTimeoutInterruptEnabled.group)
end

TPreTimeoutInterruptEnabled.from_obj = TPreTimeoutInterruptEnabled_from_obj

TPreTimeoutInterruptEnabled.proto_property = {'PreTimeoutInterruptEnabled'}

TPreTimeoutInterruptEnabled.default = {false}

TPreTimeoutInterruptEnabled.struct = {{name = 'PreTimeoutInterruptEnabled', is_array = false, struct = nil}}

function TPreTimeoutInterruptEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreTimeoutInterruptEnabled', self.PreTimeoutInterruptEnabled, 'bool', true, errs,
        need_convert)

    TPreTimeoutInterruptEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreTimeoutInterruptEnabled.proto_property, errs, need_convert)
    return self
end

function TPreTimeoutInterruptEnabled:unpack(_)
    return self.PreTimeoutInterruptEnabled
end

Watchdog2Status.PreTimeoutInterruptEnabled = TPreTimeoutInterruptEnabled

---@class Watchdog2Status.PreTimeoutInterruptType
---@field PreTimeoutInterruptType integer
local TPreTimeoutInterruptType = {}
TPreTimeoutInterruptType.__index = TPreTimeoutInterruptType
TPreTimeoutInterruptType.group = {}

local function TPreTimeoutInterruptType_from_obj(obj)
    return setmetatable(obj, TPreTimeoutInterruptType)
end

function TPreTimeoutInterruptType.new(PreTimeoutInterruptType)
    return TPreTimeoutInterruptType_from_obj({PreTimeoutInterruptType = PreTimeoutInterruptType})
end
---@param obj Watchdog2Status.PreTimeoutInterruptType
function TPreTimeoutInterruptType:init_from_obj(obj)
    self.PreTimeoutInterruptType = obj.PreTimeoutInterruptType
end

function TPreTimeoutInterruptType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreTimeoutInterruptType.group)
end

TPreTimeoutInterruptType.from_obj = TPreTimeoutInterruptType_from_obj

TPreTimeoutInterruptType.proto_property = {'PreTimeoutInterruptType'}

TPreTimeoutInterruptType.default = {0}

TPreTimeoutInterruptType.struct = {{name = 'PreTimeoutInterruptType', is_array = false, struct = nil}}

function TPreTimeoutInterruptType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreTimeoutInterruptType', self.PreTimeoutInterruptType, 'uint8', true, errs,
        need_convert)

    TPreTimeoutInterruptType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreTimeoutInterruptType.proto_property, errs, need_convert)
    return self
end

function TPreTimeoutInterruptType:unpack(_)
    return self.PreTimeoutInterruptType
end

Watchdog2Status.PreTimeoutInterruptType = TPreTimeoutInterruptType

---@class Watchdog2Status.PreTimeoutInterruptFlag
---@field PreTimeoutInterruptFlag integer
local TPreTimeoutInterruptFlag = {}
TPreTimeoutInterruptFlag.__index = TPreTimeoutInterruptFlag
TPreTimeoutInterruptFlag.group = {}

local function TPreTimeoutInterruptFlag_from_obj(obj)
    return setmetatable(obj, TPreTimeoutInterruptFlag)
end

function TPreTimeoutInterruptFlag.new(PreTimeoutInterruptFlag)
    return TPreTimeoutInterruptFlag_from_obj({PreTimeoutInterruptFlag = PreTimeoutInterruptFlag})
end
---@param obj Watchdog2Status.PreTimeoutInterruptFlag
function TPreTimeoutInterruptFlag:init_from_obj(obj)
    self.PreTimeoutInterruptFlag = obj.PreTimeoutInterruptFlag
end

function TPreTimeoutInterruptFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreTimeoutInterruptFlag.group)
end

TPreTimeoutInterruptFlag.from_obj = TPreTimeoutInterruptFlag_from_obj

TPreTimeoutInterruptFlag.proto_property = {'PreTimeoutInterruptFlag'}

TPreTimeoutInterruptFlag.default = {0}

TPreTimeoutInterruptFlag.struct = {{name = 'PreTimeoutInterruptFlag', is_array = false, struct = nil}}

function TPreTimeoutInterruptFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreTimeoutInterruptFlag', self.PreTimeoutInterruptFlag, 'uint8', true, errs,
        need_convert)

    TPreTimeoutInterruptFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreTimeoutInterruptFlag.proto_property, errs, need_convert)
    return self
end

function TPreTimeoutInterruptFlag:unpack(_)
    return self.PreTimeoutInterruptFlag
end

Watchdog2Status.PreTimeoutInterruptFlag = TPreTimeoutInterruptFlag

---@class Watchdog2Status.Running
---@field Running integer
local TRunning = {}
TRunning.__index = TRunning
TRunning.group = {}

local function TRunning_from_obj(obj)
    return setmetatable(obj, TRunning)
end

function TRunning.new(Running)
    return TRunning_from_obj({Running = Running})
end
---@param obj Watchdog2Status.Running
function TRunning:init_from_obj(obj)
    self.Running = obj.Running
end

function TRunning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRunning.group)
end

TRunning.from_obj = TRunning_from_obj

TRunning.proto_property = {'Running'}

TRunning.default = {0}

TRunning.struct = {{name = 'Running', is_array = false, struct = nil}}

function TRunning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Running', self.Running, 'uint8', true, errs, need_convert)

    TRunning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRunning.proto_property, errs, need_convert)
    return self
end

function TRunning:unpack(_)
    return self.Running
end

Watchdog2Status.Running = TRunning

---@class Watchdog2Status.SystemStartupState
---@field SystemStartupState integer
local TSystemStartupState = {}
TSystemStartupState.__index = TSystemStartupState
TSystemStartupState.group = {}

local function TSystemStartupState_from_obj(obj)
    return setmetatable(obj, TSystemStartupState)
end

function TSystemStartupState.new(SystemStartupState)
    return TSystemStartupState_from_obj({SystemStartupState = SystemStartupState})
end
---@param obj Watchdog2Status.SystemStartupState
function TSystemStartupState:init_from_obj(obj)
    self.SystemStartupState = obj.SystemStartupState
end

function TSystemStartupState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemStartupState.group)
end

TSystemStartupState.from_obj = TSystemStartupState_from_obj

TSystemStartupState.proto_property = {'SystemStartupState'}

TSystemStartupState.default = {0}

TSystemStartupState.struct = {{name = 'SystemStartupState', is_array = false, struct = nil}}

function TSystemStartupState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemStartupState', self.SystemStartupState, 'uint8', false, errs, need_convert)

    TSystemStartupState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemStartupState.proto_property, errs, need_convert)
    return self
end

function TSystemStartupState:unpack(_)
    return self.SystemStartupState
end

Watchdog2Status.SystemStartupState = TSystemStartupState

---@class Watchdog2Status.TimerUseStr
---@field TimerUseStr string
local TTimerUseStr = {}
TTimerUseStr.__index = TTimerUseStr
TTimerUseStr.group = {}

local function TTimerUseStr_from_obj(obj)
    return setmetatable(obj, TTimerUseStr)
end

function TTimerUseStr.new(TimerUseStr)
    return TTimerUseStr_from_obj({TimerUseStr = TimerUseStr})
end
---@param obj Watchdog2Status.TimerUseStr
function TTimerUseStr:init_from_obj(obj)
    self.TimerUseStr = obj.TimerUseStr
end

function TTimerUseStr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimerUseStr.group)
end

TTimerUseStr.from_obj = TTimerUseStr_from_obj

TTimerUseStr.proto_property = {'TimerUseStr'}

TTimerUseStr.default = {''}

TTimerUseStr.struct = {{name = 'TimerUseStr', is_array = false, struct = nil}}

function TTimerUseStr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimerUseStr', self.TimerUseStr, 'string', true, errs, need_convert)

    TTimerUseStr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimerUseStr.proto_property, errs, need_convert)
    return self
end

function TTimerUseStr:unpack(_)
    return self.TimerUseStr
end

Watchdog2Status.TimerUseStr = TTimerUseStr

---@class Watchdog2Status.TimerUse
---@field TimerUse integer
local TTimerUse = {}
TTimerUse.__index = TTimerUse
TTimerUse.group = {}

local function TTimerUse_from_obj(obj)
    return setmetatable(obj, TTimerUse)
end

function TTimerUse.new(TimerUse)
    return TTimerUse_from_obj({TimerUse = TimerUse})
end
---@param obj Watchdog2Status.TimerUse
function TTimerUse:init_from_obj(obj)
    self.TimerUse = obj.TimerUse
end

function TTimerUse:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimerUse.group)
end

TTimerUse.from_obj = TTimerUse_from_obj

TTimerUse.proto_property = {'TimerUse'}

TTimerUse.default = {0}

TTimerUse.struct = {{name = 'TimerUse', is_array = false, struct = nil}}

function TTimerUse:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimerUse', self.TimerUse, 'uint8', true, errs, need_convert)

    TTimerUse:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimerUse.proto_property, errs, need_convert)
    return self
end

function TTimerUse:unpack(_)
    return self.TimerUse
end

Watchdog2Status.TimerUse = TTimerUse

---@class Watchdog2Status.DoNotLog
---@field DoNotLog integer
local TDoNotLog = {}
TDoNotLog.__index = TDoNotLog
TDoNotLog.group = {}

local function TDoNotLog_from_obj(obj)
    return setmetatable(obj, TDoNotLog)
end

function TDoNotLog.new(DoNotLog)
    return TDoNotLog_from_obj({DoNotLog = DoNotLog})
end
---@param obj Watchdog2Status.DoNotLog
function TDoNotLog:init_from_obj(obj)
    self.DoNotLog = obj.DoNotLog
end

function TDoNotLog:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDoNotLog.group)
end

TDoNotLog.from_obj = TDoNotLog_from_obj

TDoNotLog.proto_property = {'DoNotLog'}

TDoNotLog.default = {0}

TDoNotLog.struct = {{name = 'DoNotLog', is_array = false, struct = nil}}

function TDoNotLog:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DoNotLog', self.DoNotLog, 'uint8', true, errs, need_convert)

    TDoNotLog:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDoNotLog.proto_property, errs, need_convert)
    return self
end

function TDoNotLog:unpack(_)
    return self.DoNotLog
end

Watchdog2Status.DoNotLog = TDoNotLog

Watchdog2Status.interface = mdb.register_interface('bmc.kepler.Watchdog2.Status', {
    DoNotLog = {'y', nil, true, nil, false},
    TimerUse = {'y', nil, true, nil, false},
    TimerUseStr = {'s', {}, true, nil, false},
    SystemStartupState = {'y', {}, false, nil, false},
    Running = {'y', {}, true, nil, false},
    PreTimeoutInterruptFlag = {'y', nil, true, nil, false},
    PreTimeoutInterruptType = {'y', {}, true, nil, false},
    PreTimeoutInterruptEnabled = {'b', {}, true, nil, false},
    PreTimeoutInterruptInterval = {'y', {}, true, nil, false},
    TimeoutAction = {'y', nil, true, nil, false},
    OEMExpirationFlag = {'y', nil, true, nil, false},
    SMSExpirationFlag = {'y', nil, true, nil, false},
    OSLoadExpirationFlag = {'y', nil, true, nil, false},
    BIOSPOSTExpirationFlag = {'y', nil, true, nil, false},
    BIOSFRB2ExpirationFlag = {'y', nil, true, nil, false},
    InitialCountdown = {'q', {}, true, nil, false},
    PresentCountdown = {'q', {}, true, nil, false},
    BIOSFailToStartFlag = {'y', nil, true, nil, false},
    ExpirationEventData = {'u', nil, true, nil, false}
}, {}, {})

return Watchdog2Status
