-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SmsStatus = {}

---@class SmsStatus.HeartBeatState
---@field HeartBeatState integer
local THeartBeatState = {}
THeartBeatState.__index = THeartBeatState
THeartBeatState.group = {}

local function THeartBeatState_from_obj(obj)
    return setmetatable(obj, THeartBeatState)
end

function THeartBeatState.new(HeartBeatState)
    return THeartBeatState_from_obj({HeartBeatState = HeartBeatState or 0})
end
---@param obj SmsStatus.HeartBeatState
function THeartBeatState:init_from_obj(obj)
    self.HeartBeatState = obj.HeartBeatState or 0
end

function THeartBeatState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THeartBeatState.group)
end

THeartBeatState.from_obj = THeartBeatState_from_obj

THeartBeatState.proto_property = {'HeartBeatState'}

THeartBeatState.default = {0}

THeartBeatState.struct = {{name = 'HeartBeatState', is_array = false, struct = nil}}

function THeartBeatState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HeartBeatState', self.HeartBeatState, 'uint8', true, errs, need_convert)

    THeartBeatState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THeartBeatState.proto_property, errs, need_convert)
    return self
end

function THeartBeatState:unpack(_)
    return self.HeartBeatState
end

SmsStatus.HeartBeatState = THeartBeatState

---@class SmsStatus.State
---@field State integer
local TState = {}
TState.__index = TState
TState.group = {}

local function TState_from_obj(obj)
    return setmetatable(obj, TState)
end

function TState.new(State)
    return TState_from_obj({State = State})
end
---@param obj SmsStatus.State
function TState:init_from_obj(obj)
    self.State = obj.State
end

function TState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TState.group)
end

TState.from_obj = TState_from_obj

TState.proto_property = {'State'}

TState.default = {0}

TState.struct = {{name = 'State', is_array = false, struct = nil}}

function TState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'State', self.State, 'uint8', true, errs, need_convert)

    TState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TState.proto_property, errs, need_convert)
    return self
end

function TState:unpack(_)
    return self.State
end

SmsStatus.State = TState

---@class SmsStatus.UpdateState
---@field UpdateState integer
local TUpdateState = {}
TUpdateState.__index = TUpdateState
TUpdateState.group = {}

local function TUpdateState_from_obj(obj)
    return setmetatable(obj, TUpdateState)
end

function TUpdateState.new(UpdateState)
    return TUpdateState_from_obj({UpdateState = UpdateState})
end
---@param obj SmsStatus.UpdateState
function TUpdateState:init_from_obj(obj)
    self.UpdateState = obj.UpdateState
end

function TUpdateState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateState.group)
end

TUpdateState.from_obj = TUpdateState_from_obj

TUpdateState.proto_property = {'UpdateState'}

TUpdateState.default = {0}

TUpdateState.struct = {{name = 'UpdateState', is_array = false, struct = nil}}

function TUpdateState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpdateState', self.UpdateState, 'uint8', true, errs, need_convert)

    TUpdateState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateState.proto_property, errs, need_convert)
    return self
end

function TUpdateState:unpack(_)
    return self.UpdateState
end

SmsStatus.UpdateState = TUpdateState

---@class SmsStatus.RunningState
---@field RunningState string
local TRunningState = {}
TRunningState.__index = TRunningState
TRunningState.group = {}

local function TRunningState_from_obj(obj)
    return setmetatable(obj, TRunningState)
end

function TRunningState.new(RunningState)
    return TRunningState_from_obj({RunningState = RunningState})
end
---@param obj SmsStatus.RunningState
function TRunningState:init_from_obj(obj)
    self.RunningState = obj.RunningState
end

function TRunningState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRunningState.group)
end

TRunningState.from_obj = TRunningState_from_obj

TRunningState.proto_property = {'RunningState'}

TRunningState.default = {''}

TRunningState.struct = {{name = 'RunningState', is_array = false, struct = nil}}

function TRunningState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RunningState', self.RunningState, 'string', true, errs, need_convert)

    TRunningState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRunningState.proto_property, errs, need_convert)
    return self
end

function TRunningState:unpack(_)
    return self.RunningState
end

SmsStatus.RunningState = TRunningState

SmsStatus.interface = mdb.register_interface('bmc.kepler.Systems.Sms.SmsStatus', {
    RunningState = {'s', nil, true, nil, false},
    UpdateState = {'y', {}, true, nil, false},
    State = {'y', nil, true, nil, false},
    HeartBeatState = {'y', nil, true, 0, false}
}, {}, {})

return SmsStatus
