-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Package = {}

---@class Package.Provider
---@field Provider string
local TProvider = {}
TProvider.__index = TProvider
TProvider.group = {}

local function TProvider_from_obj(obj)
    return setmetatable(obj, TProvider)
end

function TProvider.new(Provider)
    return TProvider_from_obj({Provider = Provider or [=[]=]})
end
---@param obj Package.Provider
function TProvider:init_from_obj(obj)
    self.Provider = obj.Provider or [=[]=]
end

function TProvider:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProvider.group)
end

TProvider.from_obj = TProvider_from_obj

TProvider.proto_property = {'Provider'}

TProvider.default = {''}

TProvider.struct = {{name = 'Provider', is_array = false, struct = nil}}

function TProvider:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Provider', self.Provider, 'string', false, errs, need_convert)

    TProvider:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProvider.proto_property, errs, need_convert)
    return self
end

function TProvider:unpack(_)
    return self.Provider
end

Package.Provider = TProvider

---@class Package.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version or [=[]=]})
end
---@param obj Package.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version or [=[]=]
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', false, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

Package.Version = TVersion

---@class Package.Customer
---@field Customer string
local TCustomer = {}
TCustomer.__index = TCustomer
TCustomer.group = {}

local function TCustomer_from_obj(obj)
    return setmetatable(obj, TCustomer)
end

function TCustomer.new(Customer)
    return TCustomer_from_obj({Customer = Customer or [=[]=]})
end
---@param obj Package.Customer
function TCustomer:init_from_obj(obj)
    self.Customer = obj.Customer or [=[]=]
end

function TCustomer:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomer.group)
end

TCustomer.from_obj = TCustomer_from_obj

TCustomer.proto_property = {'Customer'}

TCustomer.default = {''}

TCustomer.struct = {{name = 'Customer', is_array = false, struct = nil}}

function TCustomer:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Customer', self.Customer, 'string', false, errs, need_convert)

    TCustomer:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomer.proto_property, errs, need_convert)
    return self
end

function TCustomer:unpack(_)
    return self.Customer
end

Package.Customer = TCustomer

Package.interface = mdb.register_interface('bmc.kepler.Managers.Package', {
    Customer = {'s', nil, false, '', false},
    Version = {'s', nil, false, '', false},
    Provider = {'s', nil, false, '', false}
}, {}, {})

return Package
