-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FirmwareVerification = {}

---@class FirmwareVerification.GetSpiMuxChannelRsp
---@field Channel integer
local TGetSpiMuxChannelRsp = {}
TGetSpiMuxChannelRsp.__index = TGetSpiMuxChannelRsp
TGetSpiMuxChannelRsp.group = {}

local function TGetSpiMuxChannelRsp_from_obj(obj)
    return setmetatable(obj, TGetSpiMuxChannelRsp)
end

function TGetSpiMuxChannelRsp.new(Channel)
    return TGetSpiMuxChannelRsp_from_obj({Channel = Channel})
end
---@param obj FirmwareVerification.GetSpiMuxChannelRsp
function TGetSpiMuxChannelRsp:init_from_obj(obj)
    self.Channel = obj.Channel
end

function TGetSpiMuxChannelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSpiMuxChannelRsp.group)
end

TGetSpiMuxChannelRsp.from_obj = TGetSpiMuxChannelRsp_from_obj

TGetSpiMuxChannelRsp.proto_property = {'Channel'}

TGetSpiMuxChannelRsp.default = {0}

TGetSpiMuxChannelRsp.struct = {{name = 'Channel', is_array = false, struct = nil}}

function TGetSpiMuxChannelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel', self.Channel, 'uint8', false, errs, need_convert)

    TGetSpiMuxChannelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSpiMuxChannelRsp.proto_property, errs, need_convert)
    return self
end

function TGetSpiMuxChannelRsp:unpack(_)
    return self.Channel
end

FirmwareVerification.GetSpiMuxChannelRsp = TGetSpiMuxChannelRsp

---@class FirmwareVerification.GetSpiMuxChannelReq
local TGetSpiMuxChannelReq = {}
TGetSpiMuxChannelReq.__index = TGetSpiMuxChannelReq
TGetSpiMuxChannelReq.group = {}

local function TGetSpiMuxChannelReq_from_obj(obj)
    return setmetatable(obj, TGetSpiMuxChannelReq)
end

function TGetSpiMuxChannelReq.new()
    return TGetSpiMuxChannelReq_from_obj({})
end
---@param obj FirmwareVerification.GetSpiMuxChannelReq
function TGetSpiMuxChannelReq:init_from_obj(obj)

end

function TGetSpiMuxChannelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSpiMuxChannelReq.group)
end

TGetSpiMuxChannelReq.from_obj = TGetSpiMuxChannelReq_from_obj

TGetSpiMuxChannelReq.proto_property = {}

TGetSpiMuxChannelReq.default = {}

TGetSpiMuxChannelReq.struct = {}

function TGetSpiMuxChannelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetSpiMuxChannelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSpiMuxChannelReq.proto_property, errs, need_convert)
    return self
end

function TGetSpiMuxChannelReq:unpack(_)
end

FirmwareVerification.GetSpiMuxChannelReq = TGetSpiMuxChannelReq

---@class FirmwareVerification.SetSpiMuxChannelRsp
local TSetSpiMuxChannelRsp = {}
TSetSpiMuxChannelRsp.__index = TSetSpiMuxChannelRsp
TSetSpiMuxChannelRsp.group = {}

local function TSetSpiMuxChannelRsp_from_obj(obj)
    return setmetatable(obj, TSetSpiMuxChannelRsp)
end

function TSetSpiMuxChannelRsp.new()
    return TSetSpiMuxChannelRsp_from_obj({})
end
---@param obj FirmwareVerification.SetSpiMuxChannelRsp
function TSetSpiMuxChannelRsp:init_from_obj(obj)

end

function TSetSpiMuxChannelRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSpiMuxChannelRsp.group)
end

TSetSpiMuxChannelRsp.from_obj = TSetSpiMuxChannelRsp_from_obj

TSetSpiMuxChannelRsp.proto_property = {}

TSetSpiMuxChannelRsp.default = {}

TSetSpiMuxChannelRsp.struct = {}

function TSetSpiMuxChannelRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSpiMuxChannelRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSpiMuxChannelRsp.proto_property, errs, need_convert)
    return self
end

function TSetSpiMuxChannelRsp:unpack(_)
end

FirmwareVerification.SetSpiMuxChannelRsp = TSetSpiMuxChannelRsp

---@class FirmwareVerification.SetSpiMuxChannelReq
---@field Channel integer
local TSetSpiMuxChannelReq = {}
TSetSpiMuxChannelReq.__index = TSetSpiMuxChannelReq
TSetSpiMuxChannelReq.group = {}

local function TSetSpiMuxChannelReq_from_obj(obj)
    return setmetatable(obj, TSetSpiMuxChannelReq)
end

function TSetSpiMuxChannelReq.new(Channel)
    return TSetSpiMuxChannelReq_from_obj({Channel = Channel})
end
---@param obj FirmwareVerification.SetSpiMuxChannelReq
function TSetSpiMuxChannelReq:init_from_obj(obj)
    self.Channel = obj.Channel
end

function TSetSpiMuxChannelReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSpiMuxChannelReq.group)
end

TSetSpiMuxChannelReq.from_obj = TSetSpiMuxChannelReq_from_obj

TSetSpiMuxChannelReq.proto_property = {'Channel'}

TSetSpiMuxChannelReq.default = {0}

TSetSpiMuxChannelReq.struct = {{name = 'Channel', is_array = false, struct = nil}}

function TSetSpiMuxChannelReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Channel', self.Channel, 'uint8', false, errs, need_convert)

    TSetSpiMuxChannelReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSpiMuxChannelReq.proto_property, errs, need_convert)
    return self
end

function TSetSpiMuxChannelReq:unpack(_)
    return self.Channel
end

FirmwareVerification.SetSpiMuxChannelReq = TSetSpiMuxChannelReq

---@class FirmwareVerification.GetBiosVerifyResultRsp
---@field VerifyResult integer
local TGetBiosVerifyResultRsp = {}
TGetBiosVerifyResultRsp.__index = TGetBiosVerifyResultRsp
TGetBiosVerifyResultRsp.group = {}

local function TGetBiosVerifyResultRsp_from_obj(obj)
    return setmetatable(obj, TGetBiosVerifyResultRsp)
end

function TGetBiosVerifyResultRsp.new(VerifyResult)
    return TGetBiosVerifyResultRsp_from_obj({VerifyResult = VerifyResult})
end
---@param obj FirmwareVerification.GetBiosVerifyResultRsp
function TGetBiosVerifyResultRsp:init_from_obj(obj)
    self.VerifyResult = obj.VerifyResult
end

function TGetBiosVerifyResultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBiosVerifyResultRsp.group)
end

TGetBiosVerifyResultRsp.from_obj = TGetBiosVerifyResultRsp_from_obj

TGetBiosVerifyResultRsp.proto_property = {'VerifyResult'}

TGetBiosVerifyResultRsp.default = {0}

TGetBiosVerifyResultRsp.struct = {{name = 'VerifyResult', is_array = false, struct = nil}}

function TGetBiosVerifyResultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VerifyResult', self.VerifyResult, 'uint8', false, errs, need_convert)

    TGetBiosVerifyResultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBiosVerifyResultRsp.proto_property, errs, need_convert)
    return self
end

function TGetBiosVerifyResultRsp:unpack(_)
    return self.VerifyResult
end

FirmwareVerification.GetBiosVerifyResultRsp = TGetBiosVerifyResultRsp

---@class FirmwareVerification.GetBiosVerifyResultReq
local TGetBiosVerifyResultReq = {}
TGetBiosVerifyResultReq.__index = TGetBiosVerifyResultReq
TGetBiosVerifyResultReq.group = {}

local function TGetBiosVerifyResultReq_from_obj(obj)
    return setmetatable(obj, TGetBiosVerifyResultReq)
end

function TGetBiosVerifyResultReq.new()
    return TGetBiosVerifyResultReq_from_obj({})
end
---@param obj FirmwareVerification.GetBiosVerifyResultReq
function TGetBiosVerifyResultReq:init_from_obj(obj)

end

function TGetBiosVerifyResultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBiosVerifyResultReq.group)
end

TGetBiosVerifyResultReq.from_obj = TGetBiosVerifyResultReq_from_obj

TGetBiosVerifyResultReq.proto_property = {}

TGetBiosVerifyResultReq.default = {}

TGetBiosVerifyResultReq.struct = {}

function TGetBiosVerifyResultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetBiosVerifyResultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBiosVerifyResultReq.proto_property, errs, need_convert)
    return self
end

function TGetBiosVerifyResultReq:unpack(_)
end

FirmwareVerification.GetBiosVerifyResultReq = TGetBiosVerifyResultReq

---@class FirmwareVerification.StartBiosVerifyRsp
local TStartBiosVerifyRsp = {}
TStartBiosVerifyRsp.__index = TStartBiosVerifyRsp
TStartBiosVerifyRsp.group = {}

local function TStartBiosVerifyRsp_from_obj(obj)
    return setmetatable(obj, TStartBiosVerifyRsp)
end

function TStartBiosVerifyRsp.new()
    return TStartBiosVerifyRsp_from_obj({})
end
---@param obj FirmwareVerification.StartBiosVerifyRsp
function TStartBiosVerifyRsp:init_from_obj(obj)

end

function TStartBiosVerifyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartBiosVerifyRsp.group)
end

TStartBiosVerifyRsp.from_obj = TStartBiosVerifyRsp_from_obj

TStartBiosVerifyRsp.proto_property = {}

TStartBiosVerifyRsp.default = {}

TStartBiosVerifyRsp.struct = {}

function TStartBiosVerifyRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TStartBiosVerifyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartBiosVerifyRsp.proto_property, errs, need_convert)
    return self
end

function TStartBiosVerifyRsp:unpack(_)
end

FirmwareVerification.StartBiosVerifyRsp = TStartBiosVerifyRsp

---@class FirmwareVerification.StartBiosVerifyReq
---@field BiosType integer
local TStartBiosVerifyReq = {}
TStartBiosVerifyReq.__index = TStartBiosVerifyReq
TStartBiosVerifyReq.group = {}

local function TStartBiosVerifyReq_from_obj(obj)
    return setmetatable(obj, TStartBiosVerifyReq)
end

function TStartBiosVerifyReq.new(BiosType)
    return TStartBiosVerifyReq_from_obj({BiosType = BiosType})
end
---@param obj FirmwareVerification.StartBiosVerifyReq
function TStartBiosVerifyReq:init_from_obj(obj)
    self.BiosType = obj.BiosType
end

function TStartBiosVerifyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartBiosVerifyReq.group)
end

TStartBiosVerifyReq.from_obj = TStartBiosVerifyReq_from_obj

TStartBiosVerifyReq.proto_property = {'BiosType'}

TStartBiosVerifyReq.default = {0}

TStartBiosVerifyReq.struct = {{name = 'BiosType', is_array = false, struct = nil}}

function TStartBiosVerifyReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosType', self.BiosType, 'uint8', false, errs, need_convert)

    TStartBiosVerifyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartBiosVerifyReq.proto_property, errs, need_convert)
    return self
end

function TStartBiosVerifyReq:unpack(_)
    return self.BiosType
end

FirmwareVerification.StartBiosVerifyReq = TStartBiosVerifyReq

FirmwareVerification.interface = mdb.register_interface('bmc.kepler.Managers.SOC.SecureCore.FirmwareVerification', {},
    {
        StartBiosVerify = {'a{ss}y', '', TStartBiosVerifyReq, TStartBiosVerifyRsp},
        GetBiosVerifyResult = {'a{ss}', 'y', TGetBiosVerifyResultReq, TGetBiosVerifyResultRsp},
        SetSpiMuxChannel = {'a{ss}y', '', TSetSpiMuxChannelReq, TSetSpiMuxChannelRsp},
        GetSpiMuxChannel = {'a{ss}', 'y', TGetSpiMuxChannelReq, TGetSpiMuxChannelRsp}
    }, {})

return FirmwareVerification
