-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local AddrInfo = {}

---@class AddrInfo.RootBDF
---@field RootBDF string
local TRootBDF = {}
TRootBDF.__index = TRootBDF
TRootBDF.group = {}

local function TRootBDF_from_obj(obj)
    return setmetatable(obj, TRootBDF)
end

function TRootBDF.new(RootBDF)
    return TRootBDF_from_obj({RootBDF = RootBDF})
end
---@param obj AddrInfo.RootBDF
function TRootBDF:init_from_obj(obj)
    self.RootBDF = obj.RootBDF
end

function TRootBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRootBDF.group)
end

TRootBDF.from_obj = TRootBDF_from_obj

TRootBDF.proto_property = {'RootBDF'}

TRootBDF.default = {''}

TRootBDF.struct = {{name = 'RootBDF', is_array = false, struct = nil}}

function TRootBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RootBDF', self.RootBDF, 'string', true, errs, need_convert)

    TRootBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRootBDF.proto_property, errs, need_convert)
    return self
end

function TRootBDF:unpack(_)
    return self.RootBDF
end

AddrInfo.RootBDF = TRootBDF

---@class AddrInfo.PortId
---@field PortId integer
local TPortId = {}
TPortId.__index = TPortId
TPortId.group = {}

local function TPortId_from_obj(obj)
    return setmetatable(obj, TPortId)
end

function TPortId.new(PortId)
    return TPortId_from_obj({PortId = PortId})
end
---@param obj AddrInfo.PortId
function TPortId:init_from_obj(obj)
    self.PortId = obj.PortId
end

function TPortId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortId.group)
end

TPortId.from_obj = TPortId_from_obj

TPortId.proto_property = {'PortId'}

TPortId.default = {0}

TPortId.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TPortId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', true, errs, need_convert)

    TPortId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortId.proto_property, errs, need_convert)
    return self
end

function TPortId:unpack(_)
    return self.PortId
end

AddrInfo.PortId = TPortId

---@class AddrInfo.SlotId
---@field SlotId integer
local TSlotId = {}
TSlotId.__index = TSlotId
TSlotId.group = {}

local function TSlotId_from_obj(obj)
    return setmetatable(obj, TSlotId)
end

function TSlotId.new(SlotId)
    return TSlotId_from_obj({SlotId = SlotId})
end
---@param obj AddrInfo.SlotId
function TSlotId:init_from_obj(obj)
    self.SlotId = obj.SlotId
end

function TSlotId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotId.group)
end

TSlotId.from_obj = TSlotId_from_obj

TSlotId.proto_property = {'SlotId'}

TSlotId.default = {0}

TSlotId.struct = {{name = 'SlotId', is_array = false, struct = nil}}

function TSlotId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotId', self.SlotId, 'uint8', true, errs, need_convert)

    TSlotId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotId.proto_property, errs, need_convert)
    return self
end

function TSlotId:unpack(_)
    return self.SlotId
end

AddrInfo.SlotId = TSlotId

---@class AddrInfo.SocketId
---@field SocketId integer
local TSocketId = {}
TSocketId.__index = TSocketId
TSocketId.group = {}

local function TSocketId_from_obj(obj)
    return setmetatable(obj, TSocketId)
end

function TSocketId.new(SocketId)
    return TSocketId_from_obj({SocketId = SocketId})
end
---@param obj AddrInfo.SocketId
function TSocketId:init_from_obj(obj)
    self.SocketId = obj.SocketId
end

function TSocketId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketId.group)
end

TSocketId.from_obj = TSocketId_from_obj

TSocketId.proto_property = {'SocketId'}

TSocketId.default = {0}

TSocketId.struct = {{name = 'SocketId', is_array = false, struct = nil}}

function TSocketId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SocketId', self.SocketId, 'uint8', true, errs, need_convert)

    TSocketId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketId.proto_property, errs, need_convert)
    return self
end

function TSocketId:unpack(_)
    return self.SocketId
end

AddrInfo.SocketId = TSocketId

---@class AddrInfo.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj AddrInfo.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

AddrInfo.Type = TType

AddrInfo.interface = mdb.register_interface('bmc.kepler.Systems.Storage.Drive.AddrInfo', {
    Type = {'s', {}, true, nil, false},
    SocketId = {'y', {}, true, nil, false},
    SlotId = {'y', {}, true, nil, false},
    PortId = {'y', {}, true, nil, false},
    RootBDF = {'s', {}, true, nil, false}
}, {}, {})

return AddrInfo
