--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'bios.ipmi.ipmi_message'

local CT = enums.ChannelType

local BiosIpmiCmds = {}

BiosIpmiCmds.WriteSmbiosData = {
    name = 'WriteSmbiosData',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,04]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x04:1/unit:8, BiosId:1/]=] ..
        [=[unit:8, Operation:1/unit:8, Srcdata/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ RequiredOffset/string>>]=],
    req = msg.WriteSmbiosDataReq,
    rsp = msg.WriteSmbiosDataRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetBiosVersion = {
    name = 'SetBiosVersion',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x02:1/unit:8, Version/s]=] .. [=[tring>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetBiosVersionReq,
    rsp = msg.SetBiosVersionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.WriteFileToBmc = {
    name = 'WriteFileToBmc',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,09]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x09:1/unit:8, BiosId:1/]=] ..
        [=[unit:8, FileSelector:1/unit:8, Operation:1/unit:8,]=] .. [=[ Srcdata/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ RequiredOffset/string>>]=],
    req = msg.WriteFileToBmcReq,
    rsp = msg.WriteFileToBmcRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.WritePcieCardBdfToBmc = {
    name = 'WritePcieCardBdfToBmc',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[C6]=],
    decode = [=[<<0xC6:1/unit:8, MaxFrame:1/unit:8, CurrentFrame:1]=] ..
        [=[/unit:8, PCIeSlotNumber:1/unit:8, BdfData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.WritePcieCardBdfToBmcReq,
    rsp = msg.WritePcieCardBdfToBmcRsp,
    manufacturer = {-1, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.WritePcieDiskBdfToBmc = {
    name = 'WritePcieDiskBdfToBmc',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[C8]=],
    decode = [=[<<0xC8:1/unit:8, MaxFrame:1/unit:8, CurrentFrame:1]=] ..
        [=[/unit:8, PCIeSlotNumber:1/unit:8, BdfData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.WritePcieDiskBdfToBmcReq,
    rsp = msg.WritePcieDiskBdfToBmcRsp,
    manufacturer = {-1, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.WriteOcpCardBdfToBmc = {
    name = 'WriteOcpCardBdfToBmc',
    prio = types.Priority.Default,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[CC]=],
    decode = [=[<<0xCC:1/unit:8, MaxFrame:1/unit:8, CurrentFrame:1]=] ..
        [=[/unit:8, PCIeSlotNumber:1/unit:8, BdfData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.WriteOcpCardBdfToBmcReq,
    rsp = msg.WriteOcpCardBdfToBmcRsp,
    manufacturer = {-1, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.ReadFileFromBmc = {
    name = 'ReadFileFromBmc',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,0A]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x0A:1/unit:8, BiosId:1/]=] ..
        [=[unit:8, FileSelector:1/unit:8, Operation:1/unit:8,]=] .. [=[ Srcdata/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ FileBuffer/string>>]=],
    req = msg.ReadFileFromBmcReq,
    rsp = msg.ReadFileFromBmcRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetFileChanged = {
    name = 'GetFileChanged',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,0C]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x0C:1/unit:8, BiosId:1/]=] .. [=[unit:8, FileSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Changed/string>>]=],
    req = msg.GetFileChangedReq,
    rsp = msg.GetFileChangedRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetBootOptionPowerOnDelay0 = {
    name = 'GetBootOptionPowerOnDelay0',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x09,
    role = types.Role.Operator,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[65]=],
    decode = [=[<<0x65:1/unit:8, OtherSelector/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterVersion:1/unit]=] ..
        [=[:8, BootOptionSelector:1/unit:8, OtherData/string>]=] .. [=[>]=],
    req = msg.GetBootOptionPowerOnDelay0Req,
    rsp = msg.GetBootOptionPowerOnDelay0Rsp,
    manufacturer = {-1, 3},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetBootOptionPowerOnDelay1 = {
    name = 'GetBootOptionPowerOnDelay1',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x09,
    role = types.Role.Operator,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[E5]=],
    decode = [=[<<0xE5:1/unit:8, OtherSelector/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterVersion:1/unit]=] ..
        [=[:8, BootOptionSelector:1/unit:8, OtherData/string>]=] .. [=[>]=],
    req = msg.GetBootOptionPowerOnDelay1Req,
    rsp = msg.GetBootOptionPowerOnDelay1Rsp,
    manufacturer = {-1, 3},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetBootOption = {
    name = 'GetBootOption',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x09,
    role = types.Role.Operator,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<BootOptionSelector:1/unit:8, OtherSelector/strin]=] .. [=[g>>]=],
    encode = [=[<<CompletionCode:1/unit:8, OtherData/string>>]=],
    req = msg.GetBootOptionReq,
    rsp = msg.GetBootOptionRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetBootOptionPowerOnDelay0 = {
    name = 'SetBootOptionPowerOnDelay0',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x08,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[65]=],
    decode = [=[<<0x65:1/unit:8, ConfigData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetBootOptionPowerOnDelay0Req,
    rsp = msg.SetBootOptionPowerOnDelay0Rsp,
    manufacturer = {1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetBootOptionPowerOnDelay1 = {
    name = 'SetBootOptionPowerOnDelay1',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x08,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[E5]=],
    decode = [=[<<0xE5:1/unit:8, ConfigData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetBootOptionPowerOnDelay1Req,
    rsp = msg.SetBootOptionPowerOnDelay1Rsp,
    manufacturer = {1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetBootOption = {
    name = 'SetBootOption',
    prio = types.Priority.Default,
    netfn = 0x00,
    cmd = 0x08,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<BootOptionSelector:1/unit:8, ConfigData/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetBootOptionReq,
    rsp = msg.SetBootOptionRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetCachedBiosUpgradeMode = {
    name = 'SetCachedBiosUpgradeMode',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Administrator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,43,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x43:1/unit:8, 0x00:1/un]=] .. [=[it:8, UpgradeMode:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetCachedBiosUpgradeModeReq,
    rsp = msg.SetCachedBiosUpgradeModeRsp,
    manufacturer = {0, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetCachedBiosUpgradeMode = {
    name = 'GetCachedBiosUpgradeMode',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Administrator,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,43,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x43:1/unit:8, 0x01:1/un]=] .. [=[it:8, UpgradeMode/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ UpgradeMode:1/unit:8>>]=],
    req = msg.GetCachedBiosUpgradeModeReq,
    rsp = msg.GetCachedBiosUpgradeModeRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetSmBiosInfo = {
    name = 'GetSmBiosInfo',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5A]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5A:1/unit:8, BiosId:1/]=] .. [=[unit:8, InformationType:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ SmBiosInfo/string>>]=],
    req = msg.GetSmBiosInfoReq,
    rsp = msg.GetSmBiosInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetSmBiosInfo = {
    name = 'SetSmBiosInfo',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5B]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5B:1/unit:8, BiosId:1/]=] ..
        [=[unit:8, InformationType:1/unit:8, InformationLengt]=] .. [=[h:1/unit:8, Information/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetSmBiosInfoReq,
    rsp = msg.SetSmBiosInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.UpdateBiosPassword = {
    name = 'UpdateBiosPassword',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Administrator,
    privilege = privilege.UserMgmt,
    sensitive = true,
    restricted_channels = {},
    filters = [=[*,*,*,47]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x47:1/unit:8, Reserved:]=] ..
        [=[1/unit:8, ParameterSelector:1/unit:8, PasswordType]=] .. [=[:1/unit:8, Information/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, RespData/string>>]=],
    req = msg.UpdateBiosPasswordReq,
    rsp = msg.UpdateBiosPasswordRsp,
    manufacturer = {0, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.UpdateBiosStatus = {
    name = 'UpdateBiosStatus',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,03]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x03:1/unit:8, Status:1/]=] .. [=[unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.UpdateBiosStatusReq,
    rsp = msg.UpdateBiosStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetBiosBootInfo = {
    name = 'GetBiosBootInfo',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5C]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5C:1/unit:8, BiosId:1/]=] .. [=[unit:8, PropOption:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ PropLen:1/unit:8, PropValue/string>>]=],
    req = msg.GetBiosBootInfoReq,
    rsp = msg.GetBiosBootInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetBiosBootInfo = {
    name = 'SetBiosBootInfo',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5D]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5D:1/unit:8, BiosId:1/]=] ..
        [=[unit:8, PropOption:1/unit:8, PropLen:1/unit:8, Inf]=] .. [=[ormation/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetBiosBootInfoReq,
    rsp = msg.SetBiosBootInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetBiosGoldValid = {
    name = 'GetBiosGoldValid',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[59,0d]=],
    decode = [=[<<0x59:1/unit:8, 0x0d:1/unit:8, Reserved/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, Reserved:1/unit:8, Conf]=] .. [=[igurationParameter/string>>]=],
    req = msg.GetBiosGoldValidReq,
    rsp = msg.GetBiosGoldValidRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetProgressSystemInfo = {
    name = 'GetProgressSystemInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,00]=],
    decode = [=[<<GetOption:1/unit:8, 0x00:1/unit:8, SetSelector:1]=] .. [=[/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterRevision:1/uni]=] .. [=[t:8, Info/string>>]=],
    req = msg.GetProgressSystemInfoReq,
    rsp = msg.GetProgressSystemInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetSystemFirmwareVersion = {
    name = 'GetSystemFirmwareVersion',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,01]=],
    decode = [=[<<GetOption:1/unit:8, 0x01:1/unit:8, SetSelector:1]=] ..
        [=[/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterRevision:1/uni]=] ..
        [=[t:8, Info/string>>]=],
    req = msg.GetSystemFirmwareVersionReq,
    rsp = msg.GetSystemFirmwareVersionRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetSystemName = {
    name = 'GetSystemName',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,02]=],
    decode = [=[<<GetOption:1/unit:8, 0x02:1/unit:8, SetSelector:1]=] .. [=[/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterRevision:1/uni]=] .. [=[t:8, Info/string>>]=],
    req = msg.GetSystemNameReq,
    rsp = msg.GetSystemNameRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetPrimaryOperatingSystemName = {
    name = 'GetPrimaryOperatingSystemName',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,03]=],
    decode = [=[<<GetOption:1/unit:8, 0x03:1/unit:8, SetSelector:1]=] .. [=[/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterRevision:1/uni]=] .. [=[t:8, Info/string>>]=],
    req = msg.GetPrimaryOperatingSystemNameReq,
    rsp = msg.GetPrimaryOperatingSystemNameRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetOperatingSystemName = {
    name = 'GetOperatingSystemName',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,04]=],
    decode = [=[<<GetOption:1/unit:8, 0x04:1/unit:8, SetSelector:1]=] .. [=[/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterRevision:1/uni]=] .. [=[t:8, Info/string>>]=],
    req = msg.GetOperatingSystemNameReq,
    rsp = msg.GetOperatingSystemNameRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetChannelInfo = {
    name = 'GetChannelInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,05]=],
    decode = [=[<<GetOption:1/unit:8, 0x05:1/unit:8, SetSelector:1]=] .. [=[/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterRevision:1/uni]=] .. [=[t:8, Info/string>>]=],
    req = msg.GetChannelInfoReq,
    rsp = msg.GetChannelInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetBridgeSystemInfo = {
    name = 'GetBridgeSystemInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,06]=],
    decode = [=[<<GetOption:1/unit:8, 0x06:1/unit:8, SetSelector:1]=] .. [=[/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterRevision:1/uni]=] .. [=[t:8, Info/string>>]=],
    req = msg.GetBridgeSystemInfoReq,
    rsp = msg.GetBridgeSystemInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetDeviceSystemInfo = {
    name = 'GetDeviceSystemInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x59,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,07]=],
    decode = [=[<<GetOption:1/unit:8, 0x07:1/unit:8, SetSelector:1]=] .. [=[/unit:8, BlockSelector:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ParameterRevision:1/uni]=] .. [=[t:8, Info/string>>]=],
    req = msg.GetDeviceSystemInfoReq,
    rsp = msg.GetDeviceSystemInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetProgressSystemInfo = {
    name = 'SetProgressSystemInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[00]=],
    decode = [=[<<0x00:1/unit:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetProgressSystemInfoReq,
    rsp = msg.SetProgressSystemInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetSystemFirmwareVersion = {
    name = 'SetSystemFirmwareVersion',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[01]=],
    decode = [=[<<0x01:1/unit:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetSystemFirmwareVersionReq,
    rsp = msg.SetSystemFirmwareVersionRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetSystemName = {
    name = 'SetSystemName',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[02]=],
    decode = [=[<<0x02:1/unit:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetSystemNameReq,
    rsp = msg.SetSystemNameRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetPrimaryOperatingSystemName = {
    name = 'SetPrimaryOperatingSystemName',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[03]=],
    decode = [=[<<0x03:1/unit:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetPrimaryOperatingSystemNameReq,
    rsp = msg.SetPrimaryOperatingSystemNameRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetOperatingSystemName = {
    name = 'SetOperatingSystemName',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[04]=],
    decode = [=[<<0x04:1/unit:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetOperatingSystemNameReq,
    rsp = msg.SetOperatingSystemNameRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetChannelInfo = {
    name = 'SetChannelInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[05]=],
    decode = [=[<<0x05:1/unit:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetChannelInfoReq,
    rsp = msg.SetChannelInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetBridgeSystemInfo = {
    name = 'SetBridgeSystemInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[06]=],
    decode = [=[<<0x06:1/unit:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetBridgeSystemInfoReq,
    rsp = msg.SetBridgeSystemInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetDeviceSystemInfo = {
    name = 'SetDeviceSystemInfo',
    prio = types.Priority.OEM,
    netfn = 0x06,
    cmd = 0x58,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[07]=],
    decode = [=[<<0x07:1/unit:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetDeviceSystemInfoReq,
    rsp = msg.SetDeviceSystemInfoRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.UpdatePostStatus = {
    name = 'UpdatePostStatus',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,10]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x10:1/un]=] .. [=[it:8, Info/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.UpdatePostStatusReq,
    rsp = msg.UpdatePostStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetFileChanged = {
    name = 'SetFileChanged',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,0B]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x0B:1/unit:8, BiosId:1/]=] ..
        [=[unit:8, FileSelector:1/unit:8, ChangedFlag:1/unit:]=] .. [=[8, LastChangedChannel:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetFileChangedReq,
    rsp = msg.SetFileChangedRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.AddBiosLogEntry = {
    name = 'AddBiosLogEntry',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,0F]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x0F:1/unit:8, EventType]=] .. [=[:1/unit:8, Log/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.AddBiosLogEntryReq,
    rsp = msg.AddBiosLogEntryRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetCertificateDeassertion = {
    name = 'SetCertificateDeassertion',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,11,*,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x11:1/un]=] ..
        [=[it:8, EventType:1/unit:8, 0x00:1/unit:8, Info/stri]=] .. [=[ng>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetCertificateDeassertionReq,
    rsp = msg.SetCertificateDeassertionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetCertificateAssertion = {
    name = 'SetCertificateAssertion',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,11,*,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x11:1/un]=] ..
        [=[it:8, EventType:1/unit:8, 0x01:1/unit:8, Info/stri]=] .. [=[ng>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetCertificateAssertionReq,
    rsp = msg.SetCertificateAssertionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.ReportAlarm = {
    name = 'ReportAlarm',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,13]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x13:1/un]=] ..
        [=[it:8, EventType:1/unit:8, AlarmType:1/unit:8, Info]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.ReportAlarmReq,
    rsp = msg.ReportAlarmRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.ReportVRStatus = {
    name = 'ReportVRStatus',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,14]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x14:1/un]=] ..
        [=[it:8, EventType:1/unit:8, AlarmType:1/unit:8, Info]=] .. [=[/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.ReportVRStatusReq,
    rsp = msg.ReportVRStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetTeeOSVersion = {
    name = 'SetTeeOSVersion',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,4A]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x4A:1/unit:8, Type:1/un]=] .. [=[it:8, Length:1/unit:8, Version/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetTeeOSVersionReq,
    rsp = msg.SetTeeOSVersionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetVedioStatus = {
    name = 'SetVedioStatus',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,03]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x03:1/un]=] ..
        [=[it:8, EventDir:1/unit:8, DeviceStatus/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetVedioStatusReq,
    rsp = msg.SetVedioStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetKbcStatus = {
    name = 'SetKbcStatus',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,05]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x05:1/unit:8, 0x05:1/un]=] ..
        [=[it:8, EventDir:1/unit:8, DeviceStatus/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetKbcStatusReq,
    rsp = msg.SetKbcStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetBiosConfigItem = {
    name = 'SetBiosConfigItem',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5a,1c,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5a:1/unit:8, 0x001c:2/]=] ..
        [=[unit:8, Length:2/unit:8, Item:1/unit:8, Option:2/u]=] .. [=[nit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetBiosConfigItemReq,
    rsp = msg.SetBiosConfigItemRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.GetAllowedPackageType = {
    name = 'GetAllowedPackageType',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[76]=],
    decode = [=[<<0x76:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, PackageStatus:1/unit:8,]=] .. [=[ AllowedPackageType:1/unit:8>>]=],
    req = msg.GetAllowedPackageTypeReq,
    rsp = msg.GetAllowedPackageTypeRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetAllowedPackageType = {
    name = 'SetAllowedPackageType',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.Operator,
    privilege = privilege.BasicSetting,
    sensitive = false,
    restricted_channels = {},
    filters = [=[77]=],
    decode = [=[<<0x77:1/unit:8, AllowedPackageType:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8>>]=],
    req = msg.SetAllowedPackageTypeReq,
    rsp = msg.SetAllowedPackageTypeRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

BiosIpmiCmds.SetBaseOSBootEvent = {
    name = 'SetBaseOSBootEvent',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x92,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,05,15]=],
    decode = [=[<<ManuId:3/unit:8, 0x05:1/unit:8, 0x15:1/unit:8, E]=] ..
        [=[ventDir:1/unit:8, DeviceStatus:1/unit:8, Datas/str]=] .. [=[ing>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManuId:3/unit:8>>]=],
    req = msg.SetBaseOSBootEventReq,
    rsp = msg.SetBaseOSBootEventRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

return BiosIpmiCmds
