--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local WritePcieDiskBdfToBmc = {}

---@class BiosIpmiCmds.WritePcieDiskBdfToBmcReq
---@field MaxFrame integer
---@field CurrentFrame integer
---@field PCIeSlotNumber integer
---@field BdfData string
local TWritePcieDiskBdfToBmcReq = {}
TWritePcieDiskBdfToBmcReq.__index = TWritePcieDiskBdfToBmcReq
TWritePcieDiskBdfToBmcReq.group = {}

local function TWritePcieDiskBdfToBmcReq_from_obj(obj)
    return setmetatable(obj, TWritePcieDiskBdfToBmcReq)
end

function TWritePcieDiskBdfToBmcReq.new(MaxFrame, CurrentFrame, PCIeSlotNumber, BdfData)
    return TWritePcieDiskBdfToBmcReq_from_obj({
        MaxFrame = MaxFrame,
        CurrentFrame = CurrentFrame,
        PCIeSlotNumber = PCIeSlotNumber,
        BdfData = BdfData
    })
end
---@param obj BiosIpmiCmds.WritePcieDiskBdfToBmcReq
function TWritePcieDiskBdfToBmcReq:init_from_obj(obj)
    self.MaxFrame = obj.MaxFrame
    self.CurrentFrame = obj.CurrentFrame
    self.PCIeSlotNumber = obj.PCIeSlotNumber
    self.BdfData = obj.BdfData
end

function TWritePcieDiskBdfToBmcReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWritePcieDiskBdfToBmcReq.group)
end

TWritePcieDiskBdfToBmcReq.from_obj = TWritePcieDiskBdfToBmcReq_from_obj

TWritePcieDiskBdfToBmcReq.proto_property = {'MaxFrame', 'CurrentFrame', 'PCIeSlotNumber', 'BdfData'}

TWritePcieDiskBdfToBmcReq.default = {0, 0, 0, ''}

TWritePcieDiskBdfToBmcReq.struct = {
    {name = 'MaxFrame', is_array = false, struct = nil}, {name = 'CurrentFrame', is_array = false, struct = nil},
    {name = 'PCIeSlotNumber', is_array = false, struct = nil}, {name = 'BdfData', is_array = false, struct = nil}
}

function TWritePcieDiskBdfToBmcReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxFrame', self.MaxFrame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CurrentFrame', self.CurrentFrame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PCIeSlotNumber', self.PCIeSlotNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BdfData', self.BdfData, 'string', false, errs, need_convert)

    TWritePcieDiskBdfToBmcReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWritePcieDiskBdfToBmcReq.proto_property, errs, need_convert)
    return self
end

function TWritePcieDiskBdfToBmcReq:unpack(_)
    return self.MaxFrame, self.CurrentFrame, self.PCIeSlotNumber, self.BdfData
end

WritePcieDiskBdfToBmc.WritePcieDiskBdfToBmcReq = TWritePcieDiskBdfToBmcReq

---@class BiosIpmiCmds.WritePcieDiskBdfToBmcRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TWritePcieDiskBdfToBmcRsp = {}
TWritePcieDiskBdfToBmcRsp.__index = TWritePcieDiskBdfToBmcRsp
TWritePcieDiskBdfToBmcRsp.group = {}

local function TWritePcieDiskBdfToBmcRsp_from_obj(obj)
    return setmetatable(obj, TWritePcieDiskBdfToBmcRsp)
end

function TWritePcieDiskBdfToBmcRsp.new(CompletionCode, ManufactureId)
    return TWritePcieDiskBdfToBmcRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.WritePcieDiskBdfToBmcRsp
function TWritePcieDiskBdfToBmcRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TWritePcieDiskBdfToBmcRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWritePcieDiskBdfToBmcRsp.group)
end

TWritePcieDiskBdfToBmcRsp.from_obj = TWritePcieDiskBdfToBmcRsp_from_obj

TWritePcieDiskBdfToBmcRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TWritePcieDiskBdfToBmcRsp.default = {0, 0}

TWritePcieDiskBdfToBmcRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TWritePcieDiskBdfToBmcRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TWritePcieDiskBdfToBmcRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWritePcieDiskBdfToBmcRsp.proto_property, errs, need_convert)
    return self
end

function TWritePcieDiskBdfToBmcRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

WritePcieDiskBdfToBmc.WritePcieDiskBdfToBmcRsp = TWritePcieDiskBdfToBmcRsp

return WritePcieDiskBdfToBmc
