--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local WritePcieCardBdfToBmc = {}

---@class BiosIpmiCmds.WritePcieCardBdfToBmcReq
---@field MaxFrame integer
---@field CurrentFrame integer
---@field PCIeSlotNumber integer
---@field BdfData string
local TWritePcieCardBdfToBmcReq = {}
TWritePcieCardBdfToBmcReq.__index = TWritePcieCardBdfToBmcReq
TWritePcieCardBdfToBmcReq.group = {}

local function TWritePcieCardBdfToBmcReq_from_obj(obj)
    return setmetatable(obj, TWritePcieCardBdfToBmcReq)
end

function TWritePcieCardBdfToBmcReq.new(MaxFrame, CurrentFrame, PCIeSlotNumber, BdfData)
    return TWritePcieCardBdfToBmcReq_from_obj({
        MaxFrame = MaxFrame,
        CurrentFrame = CurrentFrame,
        PCIeSlotNumber = PCIeSlotNumber,
        BdfData = BdfData
    })
end
---@param obj BiosIpmiCmds.WritePcieCardBdfToBmcReq
function TWritePcieCardBdfToBmcReq:init_from_obj(obj)
    self.MaxFrame = obj.MaxFrame
    self.CurrentFrame = obj.CurrentFrame
    self.PCIeSlotNumber = obj.PCIeSlotNumber
    self.BdfData = obj.BdfData
end

function TWritePcieCardBdfToBmcReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWritePcieCardBdfToBmcReq.group)
end

TWritePcieCardBdfToBmcReq.from_obj = TWritePcieCardBdfToBmcReq_from_obj

TWritePcieCardBdfToBmcReq.proto_property = {'MaxFrame', 'CurrentFrame', 'PCIeSlotNumber', 'BdfData'}

TWritePcieCardBdfToBmcReq.default = {0, 0, 0, ''}

TWritePcieCardBdfToBmcReq.struct = {
    {name = 'MaxFrame', is_array = false, struct = nil}, {name = 'CurrentFrame', is_array = false, struct = nil},
    {name = 'PCIeSlotNumber', is_array = false, struct = nil}, {name = 'BdfData', is_array = false, struct = nil}
}

function TWritePcieCardBdfToBmcReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxFrame', self.MaxFrame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'CurrentFrame', self.CurrentFrame, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PCIeSlotNumber', self.PCIeSlotNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BdfData', self.BdfData, 'string', false, errs, need_convert)

    TWritePcieCardBdfToBmcReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWritePcieCardBdfToBmcReq.proto_property, errs, need_convert)
    return self
end

function TWritePcieCardBdfToBmcReq:unpack(_)
    return self.MaxFrame, self.CurrentFrame, self.PCIeSlotNumber, self.BdfData
end

WritePcieCardBdfToBmc.WritePcieCardBdfToBmcReq = TWritePcieCardBdfToBmcReq

---@class BiosIpmiCmds.WritePcieCardBdfToBmcRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TWritePcieCardBdfToBmcRsp = {}
TWritePcieCardBdfToBmcRsp.__index = TWritePcieCardBdfToBmcRsp
TWritePcieCardBdfToBmcRsp.group = {}

local function TWritePcieCardBdfToBmcRsp_from_obj(obj)
    return setmetatable(obj, TWritePcieCardBdfToBmcRsp)
end

function TWritePcieCardBdfToBmcRsp.new(CompletionCode, ManufactureId)
    return TWritePcieCardBdfToBmcRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.WritePcieCardBdfToBmcRsp
function TWritePcieCardBdfToBmcRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TWritePcieCardBdfToBmcRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWritePcieCardBdfToBmcRsp.group)
end

TWritePcieCardBdfToBmcRsp.from_obj = TWritePcieCardBdfToBmcRsp_from_obj

TWritePcieCardBdfToBmcRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TWritePcieCardBdfToBmcRsp.default = {0, 0}

TWritePcieCardBdfToBmcRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TWritePcieCardBdfToBmcRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TWritePcieCardBdfToBmcRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWritePcieCardBdfToBmcRsp.proto_property, errs, need_convert)
    return self
end

function TWritePcieCardBdfToBmcRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

WritePcieCardBdfToBmc.WritePcieCardBdfToBmcRsp = TWritePcieCardBdfToBmcRsp

return WritePcieCardBdfToBmc
