--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local WriteFileToBmc = {}

---@class BiosIpmiCmds.WriteFileToBmcReq
---@field ManufactureId integer
---@field BiosId integer
---@field FileSelector integer
---@field Operation integer
---@field Srcdata string
local TWriteFileToBmcReq = {}
TWriteFileToBmcReq.__index = TWriteFileToBmcReq
TWriteFileToBmcReq.group = {}

local function TWriteFileToBmcReq_from_obj(obj)
    return setmetatable(obj, TWriteFileToBmcReq)
end

function TWriteFileToBmcReq.new(ManufactureId, BiosId, FileSelector, Operation, Srcdata)
    return TWriteFileToBmcReq_from_obj({
        ManufactureId = ManufactureId,
        BiosId = BiosId,
        FileSelector = FileSelector,
        Operation = Operation,
        Srcdata = Srcdata
    })
end
---@param obj BiosIpmiCmds.WriteFileToBmcReq
function TWriteFileToBmcReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.FileSelector = obj.FileSelector
    self.Operation = obj.Operation
    self.Srcdata = obj.Srcdata
end

function TWriteFileToBmcReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteFileToBmcReq.group)
end

TWriteFileToBmcReq.from_obj = TWriteFileToBmcReq_from_obj

TWriteFileToBmcReq.proto_property = {'ManufactureId', 'BiosId', 'FileSelector', 'Operation', 'Srcdata'}

TWriteFileToBmcReq.default = {0, 0, 0, 0, ''}

TWriteFileToBmcReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'FileSelector', is_array = false, struct = nil}, {name = 'Operation', is_array = false, struct = nil},
    {name = 'Srcdata', is_array = false, struct = nil}
}

function TWriteFileToBmcReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FileSelector', self.FileSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Operation', self.Operation, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Srcdata', self.Srcdata, 'string', false, errs, need_convert)

    TWriteFileToBmcReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteFileToBmcReq.proto_property, errs, need_convert)
    return self
end

function TWriteFileToBmcReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.FileSelector, self.Operation, self.Srcdata
end

WriteFileToBmc.WriteFileToBmcReq = TWriteFileToBmcReq

---@class BiosIpmiCmds.WriteFileToBmcRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field RequiredOffset string
local TWriteFileToBmcRsp = {}
TWriteFileToBmcRsp.__index = TWriteFileToBmcRsp
TWriteFileToBmcRsp.group = {}

local function TWriteFileToBmcRsp_from_obj(obj)
    return setmetatable(obj, TWriteFileToBmcRsp)
end

function TWriteFileToBmcRsp.new(CompletionCode, ManufactureId, RequiredOffset)
    return TWriteFileToBmcRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        RequiredOffset = RequiredOffset
    })
end
---@param obj BiosIpmiCmds.WriteFileToBmcRsp
function TWriteFileToBmcRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.RequiredOffset = obj.RequiredOffset
end

function TWriteFileToBmcRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWriteFileToBmcRsp.group)
end

TWriteFileToBmcRsp.from_obj = TWriteFileToBmcRsp_from_obj

TWriteFileToBmcRsp.proto_property = {'CompletionCode', 'ManufactureId', 'RequiredOffset'}

TWriteFileToBmcRsp.default = {0, 0, ''}

TWriteFileToBmcRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'RequiredOffset', is_array = false, struct = nil}
}

function TWriteFileToBmcRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'RequiredOffset', self.RequiredOffset, 'string', false, errs, need_convert)

    TWriteFileToBmcRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWriteFileToBmcRsp.proto_property, errs, need_convert)
    return self
end

function TWriteFileToBmcRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.RequiredOffset
end

WriteFileToBmc.WriteFileToBmcRsp = TWriteFileToBmcRsp

return WriteFileToBmc
