--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local UpdateBiosStatus = {}

---@class BiosIpmiCmds.UpdateBiosStatusReq
---@field ManufactureId integer
---@field Status integer
local TUpdateBiosStatusReq = {}
TUpdateBiosStatusReq.__index = TUpdateBiosStatusReq
TUpdateBiosStatusReq.group = {}

local function TUpdateBiosStatusReq_from_obj(obj)
    return setmetatable(obj, TUpdateBiosStatusReq)
end

function TUpdateBiosStatusReq.new(ManufactureId, Status)
    return TUpdateBiosStatusReq_from_obj({ManufactureId = ManufactureId, Status = Status})
end
---@param obj BiosIpmiCmds.UpdateBiosStatusReq
function TUpdateBiosStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Status = obj.Status
end

function TUpdateBiosStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateBiosStatusReq.group)
end

TUpdateBiosStatusReq.from_obj = TUpdateBiosStatusReq_from_obj

TUpdateBiosStatusReq.proto_property = {'ManufactureId', 'Status'}

TUpdateBiosStatusReq.default = {0, 0}

TUpdateBiosStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Status', is_array = false, struct = nil}
}

function TUpdateBiosStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TUpdateBiosStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateBiosStatusReq.proto_property, errs, need_convert)
    return self
end

function TUpdateBiosStatusReq:unpack(_)
    return self.ManufactureId, self.Status
end

UpdateBiosStatus.UpdateBiosStatusReq = TUpdateBiosStatusReq

---@class BiosIpmiCmds.UpdateBiosStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TUpdateBiosStatusRsp = {}
TUpdateBiosStatusRsp.__index = TUpdateBiosStatusRsp
TUpdateBiosStatusRsp.group = {}

local function TUpdateBiosStatusRsp_from_obj(obj)
    return setmetatable(obj, TUpdateBiosStatusRsp)
end

function TUpdateBiosStatusRsp.new(CompletionCode, ManufactureId)
    return TUpdateBiosStatusRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.UpdateBiosStatusRsp
function TUpdateBiosStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TUpdateBiosStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateBiosStatusRsp.group)
end

TUpdateBiosStatusRsp.from_obj = TUpdateBiosStatusRsp_from_obj

TUpdateBiosStatusRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TUpdateBiosStatusRsp.default = {0, 0}

TUpdateBiosStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TUpdateBiosStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TUpdateBiosStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateBiosStatusRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateBiosStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

UpdateBiosStatus.UpdateBiosStatusRsp = TUpdateBiosStatusRsp

return UpdateBiosStatus
