--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local UpdateBiosPassword = {}

---@class BiosIpmiCmds.UpdateBiosPasswordReq
---@field ManufactureId integer
---@field Reserved integer
---@field ParameterSelector integer
---@field PasswordType integer
---@field Information string
local TUpdateBiosPasswordReq = {}
TUpdateBiosPasswordReq.__index = TUpdateBiosPasswordReq
TUpdateBiosPasswordReq.group = {}

local function TUpdateBiosPasswordReq_from_obj(obj)
    return setmetatable(obj, TUpdateBiosPasswordReq)
end

function TUpdateBiosPasswordReq.new(ManufactureId, Reserved, ParameterSelector, PasswordType, Information)
    return TUpdateBiosPasswordReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        ParameterSelector = ParameterSelector,
        PasswordType = PasswordType,
        Information = Information
    })
end
---@param obj BiosIpmiCmds.UpdateBiosPasswordReq
function TUpdateBiosPasswordReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.ParameterSelector = obj.ParameterSelector
    self.PasswordType = obj.PasswordType
    self.Information = obj.Information
end

function TUpdateBiosPasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateBiosPasswordReq.group)
end

TUpdateBiosPasswordReq.from_obj = TUpdateBiosPasswordReq_from_obj

TUpdateBiosPasswordReq.proto_property = {
    'ManufactureId', 'Reserved', 'ParameterSelector', 'PasswordType', 'Information'
}

TUpdateBiosPasswordReq.default = {0, 0, 0, 0, ''}

TUpdateBiosPasswordReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'ParameterSelector', is_array = false, struct = nil},
    {name = 'PasswordType', is_array = false, struct = nil}, {name = 'Information', is_array = false, struct = nil}
}

function TUpdateBiosPasswordReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterSelector', self.ParameterSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PasswordType', self.PasswordType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Information', self.Information, 'string', false, errs, need_convert)

    TUpdateBiosPasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateBiosPasswordReq.proto_property, errs, need_convert)
    return self
end

function TUpdateBiosPasswordReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.ParameterSelector, self.PasswordType, self.Information
end

UpdateBiosPassword.UpdateBiosPasswordReq = TUpdateBiosPasswordReq

---@class BiosIpmiCmds.UpdateBiosPasswordRsp
---@field CompletionCode integer
---@field RespData string
local TUpdateBiosPasswordRsp = {}
TUpdateBiosPasswordRsp.__index = TUpdateBiosPasswordRsp
TUpdateBiosPasswordRsp.group = {}

local function TUpdateBiosPasswordRsp_from_obj(obj)
    return setmetatable(obj, TUpdateBiosPasswordRsp)
end

function TUpdateBiosPasswordRsp.new(CompletionCode, RespData)
    return TUpdateBiosPasswordRsp_from_obj({CompletionCode = CompletionCode, RespData = RespData})
end
---@param obj BiosIpmiCmds.UpdateBiosPasswordRsp
function TUpdateBiosPasswordRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.RespData = obj.RespData
end

function TUpdateBiosPasswordRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateBiosPasswordRsp.group)
end

TUpdateBiosPasswordRsp.from_obj = TUpdateBiosPasswordRsp_from_obj

TUpdateBiosPasswordRsp.proto_property = {'CompletionCode', 'RespData'}

TUpdateBiosPasswordRsp.default = {0, ''}

TUpdateBiosPasswordRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'RespData', is_array = false, struct = nil}
}

function TUpdateBiosPasswordRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'RespData', self.RespData, 'string', false, errs, need_convert)

    TUpdateBiosPasswordRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateBiosPasswordRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateBiosPasswordRsp:unpack(_)
    return self.CompletionCode, self.RespData
end

UpdateBiosPassword.UpdateBiosPasswordRsp = TUpdateBiosPasswordRsp

return UpdateBiosPassword
