--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSystemName = {}

---@class BiosIpmiCmds.SetSystemNameReq
---@field Info string
local TSetSystemNameReq = {}
TSetSystemNameReq.__index = TSetSystemNameReq
TSetSystemNameReq.group = {}

local function TSetSystemNameReq_from_obj(obj)
    return setmetatable(obj, TSetSystemNameReq)
end

function TSetSystemNameReq.new(Info)
    return TSetSystemNameReq_from_obj({Info = Info})
end
---@param obj BiosIpmiCmds.SetSystemNameReq
function TSetSystemNameReq:init_from_obj(obj)
    self.Info = obj.Info
end

function TSetSystemNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSystemNameReq.group)
end

TSetSystemNameReq.from_obj = TSetSystemNameReq_from_obj

TSetSystemNameReq.proto_property = {'Info'}

TSetSystemNameReq.default = {''}

TSetSystemNameReq.struct = {{name = 'Info', is_array = false, struct = nil}}

function TSetSystemNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetSystemNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSystemNameReq.proto_property, errs, need_convert)
    return self
end

function TSetSystemNameReq:unpack(_)
    return self.Info
end

SetSystemName.SetSystemNameReq = TSetSystemNameReq

---@class BiosIpmiCmds.SetSystemNameRsp
---@field CompletionCode integer
local TSetSystemNameRsp = {}
TSetSystemNameRsp.__index = TSetSystemNameRsp
TSetSystemNameRsp.group = {}

local function TSetSystemNameRsp_from_obj(obj)
    return setmetatable(obj, TSetSystemNameRsp)
end

function TSetSystemNameRsp.new(CompletionCode)
    return TSetSystemNameRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetSystemNameRsp
function TSetSystemNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetSystemNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSystemNameRsp.group)
end

TSetSystemNameRsp.from_obj = TSetSystemNameRsp_from_obj

TSetSystemNameRsp.proto_property = {'CompletionCode'}

TSetSystemNameRsp.default = {0}

TSetSystemNameRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetSystemNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetSystemNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSystemNameRsp.proto_property, errs, need_convert)
    return self
end

function TSetSystemNameRsp:unpack(_)
    return self.CompletionCode
end

SetSystemName.SetSystemNameRsp = TSetSystemNameRsp

return SetSystemName
