--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetSmBiosInfo = {}

---@class BiosIpmiCmds.SetSmBiosInfoReq
---@field ManufactureId integer
---@field BiosId integer
---@field InformationType integer
---@field InformationLength integer
---@field Information string
local TSetSmBiosInfoReq = {}
TSetSmBiosInfoReq.__index = TSetSmBiosInfoReq
TSetSmBiosInfoReq.group = {}

local function TSetSmBiosInfoReq_from_obj(obj)
    return setmetatable(obj, TSetSmBiosInfoReq)
end

function TSetSmBiosInfoReq.new(ManufactureId, BiosId, InformationType, InformationLength, Information)
    return TSetSmBiosInfoReq_from_obj({
        ManufactureId = ManufactureId,
        BiosId = BiosId,
        InformationType = InformationType,
        InformationLength = InformationLength,
        Information = Information
    })
end
---@param obj BiosIpmiCmds.SetSmBiosInfoReq
function TSetSmBiosInfoReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.InformationType = obj.InformationType
    self.InformationLength = obj.InformationLength
    self.Information = obj.Information
end

function TSetSmBiosInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmBiosInfoReq.group)
end

TSetSmBiosInfoReq.from_obj = TSetSmBiosInfoReq_from_obj

TSetSmBiosInfoReq.proto_property = {'ManufactureId', 'BiosId', 'InformationType', 'InformationLength', 'Information'}

TSetSmBiosInfoReq.default = {0, 0, 0, 0, ''}

TSetSmBiosInfoReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'InformationType', is_array = false, struct = nil},
    {name = 'InformationLength', is_array = false, struct = nil}, {name = 'Information', is_array = false, struct = nil}
}

function TSetSmBiosInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InformationType', self.InformationType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'InformationLength', self.InformationLength, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Information', self.Information, 'string', false, errs, need_convert)

    TSetSmBiosInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmBiosInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetSmBiosInfoReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.InformationType, self.InformationLength, self.Information
end

SetSmBiosInfo.SetSmBiosInfoReq = TSetSmBiosInfoReq

---@class BiosIpmiCmds.SetSmBiosInfoRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetSmBiosInfoRsp = {}
TSetSmBiosInfoRsp.__index = TSetSmBiosInfoRsp
TSetSmBiosInfoRsp.group = {}

local function TSetSmBiosInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetSmBiosInfoRsp)
end

function TSetSmBiosInfoRsp.new(CompletionCode, ManufactureId)
    return TSetSmBiosInfoRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetSmBiosInfoRsp
function TSetSmBiosInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetSmBiosInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSmBiosInfoRsp.group)
end

TSetSmBiosInfoRsp.from_obj = TSetSmBiosInfoRsp_from_obj

TSetSmBiosInfoRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetSmBiosInfoRsp.default = {0, 0}

TSetSmBiosInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetSmBiosInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetSmBiosInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSmBiosInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetSmBiosInfoRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetSmBiosInfo.SetSmBiosInfoRsp = TSetSmBiosInfoRsp

return SetSmBiosInfo
