--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetOperatingSystemName = {}

---@class BiosIpmiCmds.SetOperatingSystemNameReq
---@field Info string
local TSetOperatingSystemNameReq = {}
TSetOperatingSystemNameReq.__index = TSetOperatingSystemNameReq
TSetOperatingSystemNameReq.group = {}

local function TSetOperatingSystemNameReq_from_obj(obj)
    return setmetatable(obj, TSetOperatingSystemNameReq)
end

function TSetOperatingSystemNameReq.new(Info)
    return TSetOperatingSystemNameReq_from_obj({Info = Info})
end
---@param obj BiosIpmiCmds.SetOperatingSystemNameReq
function TSetOperatingSystemNameReq:init_from_obj(obj)
    self.Info = obj.Info
end

function TSetOperatingSystemNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetOperatingSystemNameReq.group)
end

TSetOperatingSystemNameReq.from_obj = TSetOperatingSystemNameReq_from_obj

TSetOperatingSystemNameReq.proto_property = {'Info'}

TSetOperatingSystemNameReq.default = {''}

TSetOperatingSystemNameReq.struct = {{name = 'Info', is_array = false, struct = nil}}

function TSetOperatingSystemNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetOperatingSystemNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetOperatingSystemNameReq.proto_property, errs, need_convert)
    return self
end

function TSetOperatingSystemNameReq:unpack(_)
    return self.Info
end

SetOperatingSystemName.SetOperatingSystemNameReq = TSetOperatingSystemNameReq

---@class BiosIpmiCmds.SetOperatingSystemNameRsp
---@field CompletionCode integer
local TSetOperatingSystemNameRsp = {}
TSetOperatingSystemNameRsp.__index = TSetOperatingSystemNameRsp
TSetOperatingSystemNameRsp.group = {}

local function TSetOperatingSystemNameRsp_from_obj(obj)
    return setmetatable(obj, TSetOperatingSystemNameRsp)
end

function TSetOperatingSystemNameRsp.new(CompletionCode)
    return TSetOperatingSystemNameRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetOperatingSystemNameRsp
function TSetOperatingSystemNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetOperatingSystemNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetOperatingSystemNameRsp.group)
end

TSetOperatingSystemNameRsp.from_obj = TSetOperatingSystemNameRsp_from_obj

TSetOperatingSystemNameRsp.proto_property = {'CompletionCode'}

TSetOperatingSystemNameRsp.default = {0}

TSetOperatingSystemNameRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetOperatingSystemNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetOperatingSystemNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetOperatingSystemNameRsp.proto_property, errs, need_convert)
    return self
end

function TSetOperatingSystemNameRsp:unpack(_)
    return self.CompletionCode
end

SetOperatingSystemName.SetOperatingSystemNameRsp = TSetOperatingSystemNameRsp

return SetOperatingSystemName
