--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetFileChanged = {}

---@class BiosIpmiCmds.SetFileChangedReq
---@field ManufactureId integer
---@field BiosId integer
---@field FileSelector integer
---@field ChangedFlag integer
---@field LastChangedChannel integer
local TSetFileChangedReq = {}
TSetFileChangedReq.__index = TSetFileChangedReq
TSetFileChangedReq.group = {}

local function TSetFileChangedReq_from_obj(obj)
    return setmetatable(obj, TSetFileChangedReq)
end

function TSetFileChangedReq.new(ManufactureId, BiosId, FileSelector, ChangedFlag, LastChangedChannel)
    return TSetFileChangedReq_from_obj({
        ManufactureId = ManufactureId,
        BiosId = BiosId,
        FileSelector = FileSelector,
        ChangedFlag = ChangedFlag,
        LastChangedChannel = LastChangedChannel
    })
end
---@param obj BiosIpmiCmds.SetFileChangedReq
function TSetFileChangedReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.FileSelector = obj.FileSelector
    self.ChangedFlag = obj.ChangedFlag
    self.LastChangedChannel = obj.LastChangedChannel
end

function TSetFileChangedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFileChangedReq.group)
end

TSetFileChangedReq.from_obj = TSetFileChangedReq_from_obj

TSetFileChangedReq.proto_property = {'ManufactureId', 'BiosId', 'FileSelector', 'ChangedFlag', 'LastChangedChannel'}

TSetFileChangedReq.default = {0, 0, 0, 0, 0}

TSetFileChangedReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'FileSelector', is_array = false, struct = nil}, {name = 'ChangedFlag', is_array = false, struct = nil},
    {name = 'LastChangedChannel', is_array = false, struct = nil}
}

function TSetFileChangedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FileSelector', self.FileSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ChangedFlag', self.ChangedFlag, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LastChangedChannel', self.LastChangedChannel, 'uint8', false, errs, need_convert)

    TSetFileChangedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFileChangedReq.proto_property, errs, need_convert)
    return self
end

function TSetFileChangedReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.FileSelector, self.ChangedFlag, self.LastChangedChannel
end

SetFileChanged.SetFileChangedReq = TSetFileChangedReq

---@class BiosIpmiCmds.SetFileChangedRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetFileChangedRsp = {}
TSetFileChangedRsp.__index = TSetFileChangedRsp
TSetFileChangedRsp.group = {}

local function TSetFileChangedRsp_from_obj(obj)
    return setmetatable(obj, TSetFileChangedRsp)
end

function TSetFileChangedRsp.new(CompletionCode, ManufactureId)
    return TSetFileChangedRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.SetFileChangedRsp
function TSetFileChangedRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetFileChangedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetFileChangedRsp.group)
end

TSetFileChangedRsp.from_obj = TSetFileChangedRsp_from_obj

TSetFileChangedRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetFileChangedRsp.default = {0, 0}

TSetFileChangedRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetFileChangedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetFileChangedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetFileChangedRsp.proto_property, errs, need_convert)
    return self
end

function TSetFileChangedRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetFileChanged.SetFileChangedRsp = TSetFileChangedRsp

return SetFileChanged
