--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetChannelInfo = {}

---@class BiosIpmiCmds.SetChannelInfoReq
---@field Info string
local TSetChannelInfoReq = {}
TSetChannelInfoReq.__index = TSetChannelInfoReq
TSetChannelInfoReq.group = {}

local function TSetChannelInfoReq_from_obj(obj)
    return setmetatable(obj, TSetChannelInfoReq)
end

function TSetChannelInfoReq.new(Info)
    return TSetChannelInfoReq_from_obj({Info = Info})
end
---@param obj BiosIpmiCmds.SetChannelInfoReq
function TSetChannelInfoReq:init_from_obj(obj)
    self.Info = obj.Info
end

function TSetChannelInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetChannelInfoReq.group)
end

TSetChannelInfoReq.from_obj = TSetChannelInfoReq_from_obj

TSetChannelInfoReq.proto_property = {'Info'}

TSetChannelInfoReq.default = {''}

TSetChannelInfoReq.struct = {{name = 'Info', is_array = false, struct = nil}}

function TSetChannelInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetChannelInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetChannelInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetChannelInfoReq:unpack(_)
    return self.Info
end

SetChannelInfo.SetChannelInfoReq = TSetChannelInfoReq

---@class BiosIpmiCmds.SetChannelInfoRsp
---@field CompletionCode integer
local TSetChannelInfoRsp = {}
TSetChannelInfoRsp.__index = TSetChannelInfoRsp
TSetChannelInfoRsp.group = {}

local function TSetChannelInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetChannelInfoRsp)
end

function TSetChannelInfoRsp.new(CompletionCode)
    return TSetChannelInfoRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetChannelInfoRsp
function TSetChannelInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetChannelInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetChannelInfoRsp.group)
end

TSetChannelInfoRsp.from_obj = TSetChannelInfoRsp_from_obj

TSetChannelInfoRsp.proto_property = {'CompletionCode'}

TSetChannelInfoRsp.default = {0}

TSetChannelInfoRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetChannelInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetChannelInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetChannelInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetChannelInfoRsp:unpack(_)
    return self.CompletionCode
end

SetChannelInfo.SetChannelInfoRsp = TSetChannelInfoRsp

return SetChannelInfo
