--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBridgeSystemInfo = {}

---@class BiosIpmiCmds.SetBridgeSystemInfoReq
---@field Info string
local TSetBridgeSystemInfoReq = {}
TSetBridgeSystemInfoReq.__index = TSetBridgeSystemInfoReq
TSetBridgeSystemInfoReq.group = {}

local function TSetBridgeSystemInfoReq_from_obj(obj)
    return setmetatable(obj, TSetBridgeSystemInfoReq)
end

function TSetBridgeSystemInfoReq.new(Info)
    return TSetBridgeSystemInfoReq_from_obj({Info = Info})
end
---@param obj BiosIpmiCmds.SetBridgeSystemInfoReq
function TSetBridgeSystemInfoReq:init_from_obj(obj)
    self.Info = obj.Info
end

function TSetBridgeSystemInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBridgeSystemInfoReq.group)
end

TSetBridgeSystemInfoReq.from_obj = TSetBridgeSystemInfoReq_from_obj

TSetBridgeSystemInfoReq.proto_property = {'Info'}

TSetBridgeSystemInfoReq.default = {''}

TSetBridgeSystemInfoReq.struct = {{name = 'Info', is_array = false, struct = nil}}

function TSetBridgeSystemInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TSetBridgeSystemInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBridgeSystemInfoReq.proto_property, errs, need_convert)
    return self
end

function TSetBridgeSystemInfoReq:unpack(_)
    return self.Info
end

SetBridgeSystemInfo.SetBridgeSystemInfoReq = TSetBridgeSystemInfoReq

---@class BiosIpmiCmds.SetBridgeSystemInfoRsp
---@field CompletionCode integer
local TSetBridgeSystemInfoRsp = {}
TSetBridgeSystemInfoRsp.__index = TSetBridgeSystemInfoRsp
TSetBridgeSystemInfoRsp.group = {}

local function TSetBridgeSystemInfoRsp_from_obj(obj)
    return setmetatable(obj, TSetBridgeSystemInfoRsp)
end

function TSetBridgeSystemInfoRsp.new(CompletionCode)
    return TSetBridgeSystemInfoRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetBridgeSystemInfoRsp
function TSetBridgeSystemInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetBridgeSystemInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBridgeSystemInfoRsp.group)
end

TSetBridgeSystemInfoRsp.from_obj = TSetBridgeSystemInfoRsp_from_obj

TSetBridgeSystemInfoRsp.proto_property = {'CompletionCode'}

TSetBridgeSystemInfoRsp.default = {0}

TSetBridgeSystemInfoRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetBridgeSystemInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetBridgeSystemInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBridgeSystemInfoRsp.proto_property, errs, need_convert)
    return self
end

function TSetBridgeSystemInfoRsp:unpack(_)
    return self.CompletionCode
end

SetBridgeSystemInfo.SetBridgeSystemInfoRsp = TSetBridgeSystemInfoRsp

return SetBridgeSystemInfo
