--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBootOptionPowerOnDelay1 = {}

---@class BiosIpmiCmds.SetBootOptionPowerOnDelay1Req
---@field ConfigData string
local TSetBootOptionPowerOnDelay1Req = {}
TSetBootOptionPowerOnDelay1Req.__index = TSetBootOptionPowerOnDelay1Req
TSetBootOptionPowerOnDelay1Req.group = {}

local function TSetBootOptionPowerOnDelay1Req_from_obj(obj)
    return setmetatable(obj, TSetBootOptionPowerOnDelay1Req)
end

function TSetBootOptionPowerOnDelay1Req.new(ConfigData)
    return TSetBootOptionPowerOnDelay1Req_from_obj({ConfigData = ConfigData})
end
---@param obj BiosIpmiCmds.SetBootOptionPowerOnDelay1Req
function TSetBootOptionPowerOnDelay1Req:init_from_obj(obj)
    self.ConfigData = obj.ConfigData
end

function TSetBootOptionPowerOnDelay1Req:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionPowerOnDelay1Req.group)
end

TSetBootOptionPowerOnDelay1Req.from_obj = TSetBootOptionPowerOnDelay1Req_from_obj

TSetBootOptionPowerOnDelay1Req.proto_property = {'ConfigData'}

TSetBootOptionPowerOnDelay1Req.default = {''}

TSetBootOptionPowerOnDelay1Req.struct = {{name = 'ConfigData', is_array = false, struct = nil}}

function TSetBootOptionPowerOnDelay1Req:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConfigData', self.ConfigData, 'string', false, errs, need_convert)

    TSetBootOptionPowerOnDelay1Req:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionPowerOnDelay1Req.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionPowerOnDelay1Req:unpack(_)
    return self.ConfigData
end

SetBootOptionPowerOnDelay1.SetBootOptionPowerOnDelay1Req = TSetBootOptionPowerOnDelay1Req

---@class BiosIpmiCmds.SetBootOptionPowerOnDelay1Rsp
---@field CompletionCode integer
local TSetBootOptionPowerOnDelay1Rsp = {}
TSetBootOptionPowerOnDelay1Rsp.__index = TSetBootOptionPowerOnDelay1Rsp
TSetBootOptionPowerOnDelay1Rsp.group = {}

local function TSetBootOptionPowerOnDelay1Rsp_from_obj(obj)
    return setmetatable(obj, TSetBootOptionPowerOnDelay1Rsp)
end

function TSetBootOptionPowerOnDelay1Rsp.new(CompletionCode)
    return TSetBootOptionPowerOnDelay1Rsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetBootOptionPowerOnDelay1Rsp
function TSetBootOptionPowerOnDelay1Rsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetBootOptionPowerOnDelay1Rsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionPowerOnDelay1Rsp.group)
end

TSetBootOptionPowerOnDelay1Rsp.from_obj = TSetBootOptionPowerOnDelay1Rsp_from_obj

TSetBootOptionPowerOnDelay1Rsp.proto_property = {'CompletionCode'}

TSetBootOptionPowerOnDelay1Rsp.default = {0}

TSetBootOptionPowerOnDelay1Rsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetBootOptionPowerOnDelay1Rsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetBootOptionPowerOnDelay1Rsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionPowerOnDelay1Rsp.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionPowerOnDelay1Rsp:unpack(_)
    return self.CompletionCode
end

SetBootOptionPowerOnDelay1.SetBootOptionPowerOnDelay1Rsp = TSetBootOptionPowerOnDelay1Rsp

return SetBootOptionPowerOnDelay1
