--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBootOptionPowerOnDelay0 = {}

---@class BiosIpmiCmds.SetBootOptionPowerOnDelay0Req
---@field ConfigData string
local TSetBootOptionPowerOnDelay0Req = {}
TSetBootOptionPowerOnDelay0Req.__index = TSetBootOptionPowerOnDelay0Req
TSetBootOptionPowerOnDelay0Req.group = {}

local function TSetBootOptionPowerOnDelay0Req_from_obj(obj)
    return setmetatable(obj, TSetBootOptionPowerOnDelay0Req)
end

function TSetBootOptionPowerOnDelay0Req.new(ConfigData)
    return TSetBootOptionPowerOnDelay0Req_from_obj({ConfigData = ConfigData})
end
---@param obj BiosIpmiCmds.SetBootOptionPowerOnDelay0Req
function TSetBootOptionPowerOnDelay0Req:init_from_obj(obj)
    self.ConfigData = obj.ConfigData
end

function TSetBootOptionPowerOnDelay0Req:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionPowerOnDelay0Req.group)
end

TSetBootOptionPowerOnDelay0Req.from_obj = TSetBootOptionPowerOnDelay0Req_from_obj

TSetBootOptionPowerOnDelay0Req.proto_property = {'ConfigData'}

TSetBootOptionPowerOnDelay0Req.default = {''}

TSetBootOptionPowerOnDelay0Req.struct = {{name = 'ConfigData', is_array = false, struct = nil}}

function TSetBootOptionPowerOnDelay0Req:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConfigData', self.ConfigData, 'string', false, errs, need_convert)

    TSetBootOptionPowerOnDelay0Req:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionPowerOnDelay0Req.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionPowerOnDelay0Req:unpack(_)
    return self.ConfigData
end

SetBootOptionPowerOnDelay0.SetBootOptionPowerOnDelay0Req = TSetBootOptionPowerOnDelay0Req

---@class BiosIpmiCmds.SetBootOptionPowerOnDelay0Rsp
---@field CompletionCode integer
local TSetBootOptionPowerOnDelay0Rsp = {}
TSetBootOptionPowerOnDelay0Rsp.__index = TSetBootOptionPowerOnDelay0Rsp
TSetBootOptionPowerOnDelay0Rsp.group = {}

local function TSetBootOptionPowerOnDelay0Rsp_from_obj(obj)
    return setmetatable(obj, TSetBootOptionPowerOnDelay0Rsp)
end

function TSetBootOptionPowerOnDelay0Rsp.new(CompletionCode)
    return TSetBootOptionPowerOnDelay0Rsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetBootOptionPowerOnDelay0Rsp
function TSetBootOptionPowerOnDelay0Rsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetBootOptionPowerOnDelay0Rsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionPowerOnDelay0Rsp.group)
end

TSetBootOptionPowerOnDelay0Rsp.from_obj = TSetBootOptionPowerOnDelay0Rsp_from_obj

TSetBootOptionPowerOnDelay0Rsp.proto_property = {'CompletionCode'}

TSetBootOptionPowerOnDelay0Rsp.default = {0}

TSetBootOptionPowerOnDelay0Rsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetBootOptionPowerOnDelay0Rsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetBootOptionPowerOnDelay0Rsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionPowerOnDelay0Rsp.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionPowerOnDelay0Rsp:unpack(_)
    return self.CompletionCode
end

SetBootOptionPowerOnDelay0.SetBootOptionPowerOnDelay0Rsp = TSetBootOptionPowerOnDelay0Rsp

return SetBootOptionPowerOnDelay0
