--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetBootOption = {}

---@class BiosIpmiCmds.SetBootOptionReq
---@field BootOptionSelector integer
---@field ConfigData string
local TSetBootOptionReq = {}
TSetBootOptionReq.__index = TSetBootOptionReq
TSetBootOptionReq.group = {}

local function TSetBootOptionReq_from_obj(obj)
    return setmetatable(obj, TSetBootOptionReq)
end

function TSetBootOptionReq.new(BootOptionSelector, ConfigData)
    return TSetBootOptionReq_from_obj({BootOptionSelector = BootOptionSelector, ConfigData = ConfigData})
end
---@param obj BiosIpmiCmds.SetBootOptionReq
function TSetBootOptionReq:init_from_obj(obj)
    self.BootOptionSelector = obj.BootOptionSelector
    self.ConfigData = obj.ConfigData
end

function TSetBootOptionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionReq.group)
end

TSetBootOptionReq.from_obj = TSetBootOptionReq_from_obj

TSetBootOptionReq.proto_property = {'BootOptionSelector', 'ConfigData'}

TSetBootOptionReq.default = {0, ''}

TSetBootOptionReq.struct = {
    {name = 'BootOptionSelector', is_array = false, struct = nil}, {name = 'ConfigData', is_array = false, struct = nil}
}

function TSetBootOptionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BootOptionSelector', self.BootOptionSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ConfigData', self.ConfigData, 'string', false, errs, need_convert)

    TSetBootOptionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionReq.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionReq:unpack(_)
    return self.BootOptionSelector, self.ConfigData
end

SetBootOption.SetBootOptionReq = TSetBootOptionReq

---@class BiosIpmiCmds.SetBootOptionRsp
---@field CompletionCode integer
local TSetBootOptionRsp = {}
TSetBootOptionRsp.__index = TSetBootOptionRsp
TSetBootOptionRsp.group = {}

local function TSetBootOptionRsp_from_obj(obj)
    return setmetatable(obj, TSetBootOptionRsp)
end

function TSetBootOptionRsp.new(CompletionCode)
    return TSetBootOptionRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetBootOptionRsp
function TSetBootOptionRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetBootOptionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBootOptionRsp.group)
end

TSetBootOptionRsp.from_obj = TSetBootOptionRsp_from_obj

TSetBootOptionRsp.proto_property = {'CompletionCode'}

TSetBootOptionRsp.default = {0}

TSetBootOptionRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetBootOptionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetBootOptionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBootOptionRsp.proto_property, errs, need_convert)
    return self
end

function TSetBootOptionRsp:unpack(_)
    return self.CompletionCode
end

SetBootOption.SetBootOptionRsp = TSetBootOptionRsp

return SetBootOption
