--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetAllowedPackageType = {}

---@class BiosIpmiCmds.SetAllowedPackageTypeReq
---@field AllowedPackageType integer
local TSetAllowedPackageTypeReq = {}
TSetAllowedPackageTypeReq.__index = TSetAllowedPackageTypeReq
TSetAllowedPackageTypeReq.group = {}

local function TSetAllowedPackageTypeReq_from_obj(obj)
    return setmetatable(obj, TSetAllowedPackageTypeReq)
end

function TSetAllowedPackageTypeReq.new(AllowedPackageType)
    return TSetAllowedPackageTypeReq_from_obj({AllowedPackageType = AllowedPackageType})
end
---@param obj BiosIpmiCmds.SetAllowedPackageTypeReq
function TSetAllowedPackageTypeReq:init_from_obj(obj)
    self.AllowedPackageType = obj.AllowedPackageType
end

function TSetAllowedPackageTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAllowedPackageTypeReq.group)
end

TSetAllowedPackageTypeReq.from_obj = TSetAllowedPackageTypeReq_from_obj

TSetAllowedPackageTypeReq.proto_property = {'AllowedPackageType'}

TSetAllowedPackageTypeReq.default = {0}

TSetAllowedPackageTypeReq.struct = {{name = 'AllowedPackageType', is_array = false, struct = nil}}

function TSetAllowedPackageTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AllowedPackageType', self.AllowedPackageType, 'uint8', false, errs, need_convert)

    TSetAllowedPackageTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAllowedPackageTypeReq.proto_property, errs, need_convert)
    return self
end

function TSetAllowedPackageTypeReq:unpack(_)
    return self.AllowedPackageType
end

SetAllowedPackageType.SetAllowedPackageTypeReq = TSetAllowedPackageTypeReq

---@class BiosIpmiCmds.SetAllowedPackageTypeRsp
---@field CompletionCode integer
local TSetAllowedPackageTypeRsp = {}
TSetAllowedPackageTypeRsp.__index = TSetAllowedPackageTypeRsp
TSetAllowedPackageTypeRsp.group = {}

local function TSetAllowedPackageTypeRsp_from_obj(obj)
    return setmetatable(obj, TSetAllowedPackageTypeRsp)
end

function TSetAllowedPackageTypeRsp.new(CompletionCode)
    return TSetAllowedPackageTypeRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj BiosIpmiCmds.SetAllowedPackageTypeRsp
function TSetAllowedPackageTypeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetAllowedPackageTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAllowedPackageTypeRsp.group)
end

TSetAllowedPackageTypeRsp.from_obj = TSetAllowedPackageTypeRsp_from_obj

TSetAllowedPackageTypeRsp.proto_property = {'CompletionCode'}

TSetAllowedPackageTypeRsp.default = {0}

TSetAllowedPackageTypeRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetAllowedPackageTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetAllowedPackageTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAllowedPackageTypeRsp.proto_property, errs, need_convert)
    return self
end

function TSetAllowedPackageTypeRsp:unpack(_)
    return self.CompletionCode
end

SetAllowedPackageType.SetAllowedPackageTypeRsp = TSetAllowedPackageTypeRsp

return SetAllowedPackageType
