--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReportVRStatus = {}

---@class BiosIpmiCmds.ReportVRStatusReq
---@field ManufactureId integer
---@field EventType integer
---@field AlarmType integer
---@field Info string
local TReportVRStatusReq = {}
TReportVRStatusReq.__index = TReportVRStatusReq
TReportVRStatusReq.group = {}

local function TReportVRStatusReq_from_obj(obj)
    return setmetatable(obj, TReportVRStatusReq)
end

function TReportVRStatusReq.new(ManufactureId, EventType, AlarmType, Info)
    return TReportVRStatusReq_from_obj({
        ManufactureId = ManufactureId,
        EventType = EventType,
        AlarmType = AlarmType,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.ReportVRStatusReq
function TReportVRStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.EventType = obj.EventType
    self.AlarmType = obj.AlarmType
    self.Info = obj.Info
end

function TReportVRStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReportVRStatusReq.group)
end

TReportVRStatusReq.from_obj = TReportVRStatusReq_from_obj

TReportVRStatusReq.proto_property = {'ManufactureId', 'EventType', 'AlarmType', 'Info'}

TReportVRStatusReq.default = {0, 0, 0, ''}

TReportVRStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'EventType', is_array = false, struct = nil},
    {name = 'AlarmType', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TReportVRStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventType', self.EventType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AlarmType', self.AlarmType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TReportVRStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReportVRStatusReq.proto_property, errs, need_convert)
    return self
end

function TReportVRStatusReq:unpack(_)
    return self.ManufactureId, self.EventType, self.AlarmType, self.Info
end

ReportVRStatus.ReportVRStatusReq = TReportVRStatusReq

---@class BiosIpmiCmds.ReportVRStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TReportVRStatusRsp = {}
TReportVRStatusRsp.__index = TReportVRStatusRsp
TReportVRStatusRsp.group = {}

local function TReportVRStatusRsp_from_obj(obj)
    return setmetatable(obj, TReportVRStatusRsp)
end

function TReportVRStatusRsp.new(CompletionCode, ManufactureId)
    return TReportVRStatusRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.ReportVRStatusRsp
function TReportVRStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TReportVRStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReportVRStatusRsp.group)
end

TReportVRStatusRsp.from_obj = TReportVRStatusRsp_from_obj

TReportVRStatusRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TReportVRStatusRsp.default = {0, 0}

TReportVRStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TReportVRStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TReportVRStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReportVRStatusRsp.proto_property, errs, need_convert)
    return self
end

function TReportVRStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

ReportVRStatus.ReportVRStatusRsp = TReportVRStatusRsp

return ReportVRStatus
