--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReportAlarm = {}

---@class BiosIpmiCmds.ReportAlarmReq
---@field ManufactureId integer
---@field EventType integer
---@field AlarmType integer
---@field Info string
local TReportAlarmReq = {}
TReportAlarmReq.__index = TReportAlarmReq
TReportAlarmReq.group = {}

local function TReportAlarmReq_from_obj(obj)
    return setmetatable(obj, TReportAlarmReq)
end

function TReportAlarmReq.new(ManufactureId, EventType, AlarmType, Info)
    return TReportAlarmReq_from_obj({
        ManufactureId = ManufactureId,
        EventType = EventType,
        AlarmType = AlarmType,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.ReportAlarmReq
function TReportAlarmReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.EventType = obj.EventType
    self.AlarmType = obj.AlarmType
    self.Info = obj.Info
end

function TReportAlarmReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReportAlarmReq.group)
end

TReportAlarmReq.from_obj = TReportAlarmReq_from_obj

TReportAlarmReq.proto_property = {'ManufactureId', 'EventType', 'AlarmType', 'Info'}

TReportAlarmReq.default = {0, 0, 0, ''}

TReportAlarmReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'EventType', is_array = false, struct = nil},
    {name = 'AlarmType', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TReportAlarmReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EventType', self.EventType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AlarmType', self.AlarmType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TReportAlarmReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReportAlarmReq.proto_property, errs, need_convert)
    return self
end

function TReportAlarmReq:unpack(_)
    return self.ManufactureId, self.EventType, self.AlarmType, self.Info
end

ReportAlarm.ReportAlarmReq = TReportAlarmReq

---@class BiosIpmiCmds.ReportAlarmRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TReportAlarmRsp = {}
TReportAlarmRsp.__index = TReportAlarmRsp
TReportAlarmRsp.group = {}

local function TReportAlarmRsp_from_obj(obj)
    return setmetatable(obj, TReportAlarmRsp)
end

function TReportAlarmRsp.new(CompletionCode, ManufactureId)
    return TReportAlarmRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj BiosIpmiCmds.ReportAlarmRsp
function TReportAlarmRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TReportAlarmRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReportAlarmRsp.group)
end

TReportAlarmRsp.from_obj = TReportAlarmRsp_from_obj

TReportAlarmRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TReportAlarmRsp.default = {0, 0}

TReportAlarmRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TReportAlarmRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TReportAlarmRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReportAlarmRsp.proto_property, errs, need_convert)
    return self
end

function TReportAlarmRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

ReportAlarm.ReportAlarmRsp = TReportAlarmRsp

return ReportAlarm
