--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local ReadFileFromBmc = {}

---@class BiosIpmiCmds.ReadFileFromBmcReq
---@field ManufactureId integer
---@field BiosId integer
---@field FileSelector integer
---@field Operation integer
---@field Srcdata string
local TReadFileFromBmcReq = {}
TReadFileFromBmcReq.__index = TReadFileFromBmcReq
TReadFileFromBmcReq.group = {}

local function TReadFileFromBmcReq_from_obj(obj)
    return setmetatable(obj, TReadFileFromBmcReq)
end

function TReadFileFromBmcReq.new(ManufactureId, BiosId, FileSelector, Operation, Srcdata)
    return TReadFileFromBmcReq_from_obj({
        ManufactureId = ManufactureId,
        BiosId = BiosId,
        FileSelector = FileSelector,
        Operation = Operation,
        Srcdata = Srcdata
    })
end
---@param obj BiosIpmiCmds.ReadFileFromBmcReq
function TReadFileFromBmcReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.FileSelector = obj.FileSelector
    self.Operation = obj.Operation
    self.Srcdata = obj.Srcdata
end

function TReadFileFromBmcReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadFileFromBmcReq.group)
end

TReadFileFromBmcReq.from_obj = TReadFileFromBmcReq_from_obj

TReadFileFromBmcReq.proto_property = {'ManufactureId', 'BiosId', 'FileSelector', 'Operation', 'Srcdata'}

TReadFileFromBmcReq.default = {0, 0, 0, 0, ''}

TReadFileFromBmcReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'FileSelector', is_array = false, struct = nil}, {name = 'Operation', is_array = false, struct = nil},
    {name = 'Srcdata', is_array = false, struct = nil}
}

function TReadFileFromBmcReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FileSelector', self.FileSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Operation', self.Operation, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Srcdata', self.Srcdata, 'string', false, errs, need_convert)

    TReadFileFromBmcReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadFileFromBmcReq.proto_property, errs, need_convert)
    return self
end

function TReadFileFromBmcReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.FileSelector, self.Operation, self.Srcdata
end

ReadFileFromBmc.ReadFileFromBmcReq = TReadFileFromBmcReq

---@class BiosIpmiCmds.ReadFileFromBmcRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field FileBuffer string
local TReadFileFromBmcRsp = {}
TReadFileFromBmcRsp.__index = TReadFileFromBmcRsp
TReadFileFromBmcRsp.group = {}

local function TReadFileFromBmcRsp_from_obj(obj)
    return setmetatable(obj, TReadFileFromBmcRsp)
end

function TReadFileFromBmcRsp.new(CompletionCode, ManufactureId, FileBuffer)
    return TReadFileFromBmcRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        FileBuffer = FileBuffer
    })
end
---@param obj BiosIpmiCmds.ReadFileFromBmcRsp
function TReadFileFromBmcRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.FileBuffer = obj.FileBuffer
end

function TReadFileFromBmcRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadFileFromBmcRsp.group)
end

TReadFileFromBmcRsp.from_obj = TReadFileFromBmcRsp_from_obj

TReadFileFromBmcRsp.proto_property = {'CompletionCode', 'ManufactureId', 'FileBuffer'}

TReadFileFromBmcRsp.default = {0, 0, ''}

TReadFileFromBmcRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'FileBuffer', is_array = false, struct = nil}
}

function TReadFileFromBmcRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'FileBuffer', self.FileBuffer, 'string', false, errs, need_convert)

    TReadFileFromBmcRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadFileFromBmcRsp.proto_property, errs, need_convert)
    return self
end

function TReadFileFromBmcRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.FileBuffer
end

ReadFileFromBmc.ReadFileFromBmcRsp = TReadFileFromBmcRsp

return ReadFileFromBmc
