--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetSystemName = {}

---@class BiosIpmiCmds.GetSystemNameReq
---@field GetOption integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetSystemNameReq = {}
TGetSystemNameReq.__index = TGetSystemNameReq
TGetSystemNameReq.group = {}

local function TGetSystemNameReq_from_obj(obj)
    return setmetatable(obj, TGetSystemNameReq)
end

function TGetSystemNameReq.new(GetOption, SetSelector, BlockSelector)
    return TGetSystemNameReq_from_obj({GetOption = GetOption, SetSelector = SetSelector, BlockSelector = BlockSelector})
end
---@param obj BiosIpmiCmds.GetSystemNameReq
function TGetSystemNameReq:init_from_obj(obj)
    self.GetOption = obj.GetOption
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetSystemNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSystemNameReq.group)
end

TGetSystemNameReq.from_obj = TGetSystemNameReq_from_obj

TGetSystemNameReq.proto_property = {'GetOption', 'SetSelector', 'BlockSelector'}

TGetSystemNameReq.default = {0, 0, 0}

TGetSystemNameReq.struct = {
    {name = 'GetOption', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetSystemNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetOption', self.GetOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)

    TGetSystemNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSystemNameReq.proto_property, errs, need_convert)
    return self
end

function TGetSystemNameReq:unpack(_)
    return self.GetOption, self.SetSelector, self.BlockSelector
end

GetSystemName.GetSystemNameReq = TGetSystemNameReq

---@class BiosIpmiCmds.GetSystemNameRsp
---@field CompletionCode integer
---@field ParameterRevision integer
---@field Info string
local TGetSystemNameRsp = {}
TGetSystemNameRsp.__index = TGetSystemNameRsp
TGetSystemNameRsp.group = {}

local function TGetSystemNameRsp_from_obj(obj)
    return setmetatable(obj, TGetSystemNameRsp)
end

function TGetSystemNameRsp.new(CompletionCode, ParameterRevision, Info)
    return TGetSystemNameRsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterRevision = ParameterRevision,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetSystemNameRsp
function TGetSystemNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterRevision = obj.ParameterRevision
    self.Info = obj.Info
end

function TGetSystemNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSystemNameRsp.group)
end

TGetSystemNameRsp.from_obj = TGetSystemNameRsp_from_obj

TGetSystemNameRsp.proto_property = {'CompletionCode', 'ParameterRevision', 'Info'}

TGetSystemNameRsp.default = {0, 0, ''}

TGetSystemNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterRevision', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TGetSystemNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterRevision', self.ParameterRevision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetSystemNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSystemNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetSystemNameRsp:unpack(_)
    return self.CompletionCode, self.ParameterRevision, self.Info
end

GetSystemName.GetSystemNameRsp = TGetSystemNameRsp

return GetSystemName
