--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetProgressSystemInfo = {}

---@class BiosIpmiCmds.GetProgressSystemInfoReq
---@field GetOption integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetProgressSystemInfoReq = {}
TGetProgressSystemInfoReq.__index = TGetProgressSystemInfoReq
TGetProgressSystemInfoReq.group = {}

local function TGetProgressSystemInfoReq_from_obj(obj)
    return setmetatable(obj, TGetProgressSystemInfoReq)
end

function TGetProgressSystemInfoReq.new(GetOption, SetSelector, BlockSelector)
    return TGetProgressSystemInfoReq_from_obj({
        GetOption = GetOption,
        SetSelector = SetSelector,
        BlockSelector = BlockSelector
    })
end
---@param obj BiosIpmiCmds.GetProgressSystemInfoReq
function TGetProgressSystemInfoReq:init_from_obj(obj)
    self.GetOption = obj.GetOption
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetProgressSystemInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetProgressSystemInfoReq.group)
end

TGetProgressSystemInfoReq.from_obj = TGetProgressSystemInfoReq_from_obj

TGetProgressSystemInfoReq.proto_property = {'GetOption', 'SetSelector', 'BlockSelector'}

TGetProgressSystemInfoReq.default = {0, 0, 0}

TGetProgressSystemInfoReq.struct = {
    {name = 'GetOption', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetProgressSystemInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetOption', self.GetOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)

    TGetProgressSystemInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetProgressSystemInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetProgressSystemInfoReq:unpack(_)
    return self.GetOption, self.SetSelector, self.BlockSelector
end

GetProgressSystemInfo.GetProgressSystemInfoReq = TGetProgressSystemInfoReq

---@class BiosIpmiCmds.GetProgressSystemInfoRsp
---@field CompletionCode integer
---@field ParameterRevision integer
---@field Info string
local TGetProgressSystemInfoRsp = {}
TGetProgressSystemInfoRsp.__index = TGetProgressSystemInfoRsp
TGetProgressSystemInfoRsp.group = {}

local function TGetProgressSystemInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetProgressSystemInfoRsp)
end

function TGetProgressSystemInfoRsp.new(CompletionCode, ParameterRevision, Info)
    return TGetProgressSystemInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterRevision = ParameterRevision,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetProgressSystemInfoRsp
function TGetProgressSystemInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterRevision = obj.ParameterRevision
    self.Info = obj.Info
end

function TGetProgressSystemInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetProgressSystemInfoRsp.group)
end

TGetProgressSystemInfoRsp.from_obj = TGetProgressSystemInfoRsp_from_obj

TGetProgressSystemInfoRsp.proto_property = {'CompletionCode', 'ParameterRevision', 'Info'}

TGetProgressSystemInfoRsp.default = {0, 0, ''}

TGetProgressSystemInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterRevision', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TGetProgressSystemInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterRevision', self.ParameterRevision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetProgressSystemInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetProgressSystemInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetProgressSystemInfoRsp:unpack(_)
    return self.CompletionCode, self.ParameterRevision, self.Info
end

GetProgressSystemInfo.GetProgressSystemInfoRsp = TGetProgressSystemInfoRsp

return GetProgressSystemInfo
