--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPrimaryOperatingSystemName = {}

---@class BiosIpmiCmds.GetPrimaryOperatingSystemNameReq
---@field GetOption integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetPrimaryOperatingSystemNameReq = {}
TGetPrimaryOperatingSystemNameReq.__index = TGetPrimaryOperatingSystemNameReq
TGetPrimaryOperatingSystemNameReq.group = {}

local function TGetPrimaryOperatingSystemNameReq_from_obj(obj)
    return setmetatable(obj, TGetPrimaryOperatingSystemNameReq)
end

function TGetPrimaryOperatingSystemNameReq.new(GetOption, SetSelector, BlockSelector)
    return TGetPrimaryOperatingSystemNameReq_from_obj({
        GetOption = GetOption,
        SetSelector = SetSelector,
        BlockSelector = BlockSelector
    })
end
---@param obj BiosIpmiCmds.GetPrimaryOperatingSystemNameReq
function TGetPrimaryOperatingSystemNameReq:init_from_obj(obj)
    self.GetOption = obj.GetOption
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetPrimaryOperatingSystemNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPrimaryOperatingSystemNameReq.group)
end

TGetPrimaryOperatingSystemNameReq.from_obj = TGetPrimaryOperatingSystemNameReq_from_obj

TGetPrimaryOperatingSystemNameReq.proto_property = {'GetOption', 'SetSelector', 'BlockSelector'}

TGetPrimaryOperatingSystemNameReq.default = {0, 0, 0}

TGetPrimaryOperatingSystemNameReq.struct = {
    {name = 'GetOption', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetPrimaryOperatingSystemNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetOption', self.GetOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)

    TGetPrimaryOperatingSystemNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPrimaryOperatingSystemNameReq.proto_property, errs, need_convert)
    return self
end

function TGetPrimaryOperatingSystemNameReq:unpack(_)
    return self.GetOption, self.SetSelector, self.BlockSelector
end

GetPrimaryOperatingSystemName.GetPrimaryOperatingSystemNameReq = TGetPrimaryOperatingSystemNameReq

---@class BiosIpmiCmds.GetPrimaryOperatingSystemNameRsp
---@field CompletionCode integer
---@field ParameterRevision integer
---@field Info string
local TGetPrimaryOperatingSystemNameRsp = {}
TGetPrimaryOperatingSystemNameRsp.__index = TGetPrimaryOperatingSystemNameRsp
TGetPrimaryOperatingSystemNameRsp.group = {}

local function TGetPrimaryOperatingSystemNameRsp_from_obj(obj)
    return setmetatable(obj, TGetPrimaryOperatingSystemNameRsp)
end

function TGetPrimaryOperatingSystemNameRsp.new(CompletionCode, ParameterRevision, Info)
    return TGetPrimaryOperatingSystemNameRsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterRevision = ParameterRevision,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetPrimaryOperatingSystemNameRsp
function TGetPrimaryOperatingSystemNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterRevision = obj.ParameterRevision
    self.Info = obj.Info
end

function TGetPrimaryOperatingSystemNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPrimaryOperatingSystemNameRsp.group)
end

TGetPrimaryOperatingSystemNameRsp.from_obj = TGetPrimaryOperatingSystemNameRsp_from_obj

TGetPrimaryOperatingSystemNameRsp.proto_property = {'CompletionCode', 'ParameterRevision', 'Info'}

TGetPrimaryOperatingSystemNameRsp.default = {0, 0, ''}

TGetPrimaryOperatingSystemNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterRevision', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TGetPrimaryOperatingSystemNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterRevision', self.ParameterRevision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetPrimaryOperatingSystemNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPrimaryOperatingSystemNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetPrimaryOperatingSystemNameRsp:unpack(_)
    return self.CompletionCode, self.ParameterRevision, self.Info
end

GetPrimaryOperatingSystemName.GetPrimaryOperatingSystemNameRsp = TGetPrimaryOperatingSystemNameRsp

return GetPrimaryOperatingSystemName
