--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetOperatingSystemName = {}

---@class BiosIpmiCmds.GetOperatingSystemNameReq
---@field GetOption integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetOperatingSystemNameReq = {}
TGetOperatingSystemNameReq.__index = TGetOperatingSystemNameReq
TGetOperatingSystemNameReq.group = {}

local function TGetOperatingSystemNameReq_from_obj(obj)
    return setmetatable(obj, TGetOperatingSystemNameReq)
end

function TGetOperatingSystemNameReq.new(GetOption, SetSelector, BlockSelector)
    return TGetOperatingSystemNameReq_from_obj({
        GetOption = GetOption,
        SetSelector = SetSelector,
        BlockSelector = BlockSelector
    })
end
---@param obj BiosIpmiCmds.GetOperatingSystemNameReq
function TGetOperatingSystemNameReq:init_from_obj(obj)
    self.GetOption = obj.GetOption
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetOperatingSystemNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetOperatingSystemNameReq.group)
end

TGetOperatingSystemNameReq.from_obj = TGetOperatingSystemNameReq_from_obj

TGetOperatingSystemNameReq.proto_property = {'GetOption', 'SetSelector', 'BlockSelector'}

TGetOperatingSystemNameReq.default = {0, 0, 0}

TGetOperatingSystemNameReq.struct = {
    {name = 'GetOption', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetOperatingSystemNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetOption', self.GetOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)

    TGetOperatingSystemNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetOperatingSystemNameReq.proto_property, errs, need_convert)
    return self
end

function TGetOperatingSystemNameReq:unpack(_)
    return self.GetOption, self.SetSelector, self.BlockSelector
end

GetOperatingSystemName.GetOperatingSystemNameReq = TGetOperatingSystemNameReq

---@class BiosIpmiCmds.GetOperatingSystemNameRsp
---@field CompletionCode integer
---@field ParameterRevision integer
---@field Info string
local TGetOperatingSystemNameRsp = {}
TGetOperatingSystemNameRsp.__index = TGetOperatingSystemNameRsp
TGetOperatingSystemNameRsp.group = {}

local function TGetOperatingSystemNameRsp_from_obj(obj)
    return setmetatable(obj, TGetOperatingSystemNameRsp)
end

function TGetOperatingSystemNameRsp.new(CompletionCode, ParameterRevision, Info)
    return TGetOperatingSystemNameRsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterRevision = ParameterRevision,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetOperatingSystemNameRsp
function TGetOperatingSystemNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterRevision = obj.ParameterRevision
    self.Info = obj.Info
end

function TGetOperatingSystemNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetOperatingSystemNameRsp.group)
end

TGetOperatingSystemNameRsp.from_obj = TGetOperatingSystemNameRsp_from_obj

TGetOperatingSystemNameRsp.proto_property = {'CompletionCode', 'ParameterRevision', 'Info'}

TGetOperatingSystemNameRsp.default = {0, 0, ''}

TGetOperatingSystemNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterRevision', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TGetOperatingSystemNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterRevision', self.ParameterRevision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetOperatingSystemNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetOperatingSystemNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetOperatingSystemNameRsp:unpack(_)
    return self.CompletionCode, self.ParameterRevision, self.Info
end

GetOperatingSystemName.GetOperatingSystemNameRsp = TGetOperatingSystemNameRsp

return GetOperatingSystemName
