--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetFileChanged = {}

---@class BiosIpmiCmds.GetFileChangedReq
---@field ManufactureId integer
---@field BiosId integer
---@field FileSelector integer
local TGetFileChangedReq = {}
TGetFileChangedReq.__index = TGetFileChangedReq
TGetFileChangedReq.group = {}

local function TGetFileChangedReq_from_obj(obj)
    return setmetatable(obj, TGetFileChangedReq)
end

function TGetFileChangedReq.new(ManufactureId, BiosId, FileSelector)
    return TGetFileChangedReq_from_obj({ManufactureId = ManufactureId, BiosId = BiosId, FileSelector = FileSelector})
end
---@param obj BiosIpmiCmds.GetFileChangedReq
function TGetFileChangedReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.BiosId = obj.BiosId
    self.FileSelector = obj.FileSelector
end

function TGetFileChangedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFileChangedReq.group)
end

TGetFileChangedReq.from_obj = TGetFileChangedReq_from_obj

TGetFileChangedReq.proto_property = {'ManufactureId', 'BiosId', 'FileSelector'}

TGetFileChangedReq.default = {0, 0, 0}

TGetFileChangedReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'BiosId', is_array = false, struct = nil},
    {name = 'FileSelector', is_array = false, struct = nil}
}

function TGetFileChangedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'BiosId', self.BiosId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FileSelector', self.FileSelector, 'uint8', false, errs, need_convert)

    TGetFileChangedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFileChangedReq.proto_property, errs, need_convert)
    return self
end

function TGetFileChangedReq:unpack(_)
    return self.ManufactureId, self.BiosId, self.FileSelector
end

GetFileChanged.GetFileChangedReq = TGetFileChangedReq

---@class BiosIpmiCmds.GetFileChangedRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Changed string
local TGetFileChangedRsp = {}
TGetFileChangedRsp.__index = TGetFileChangedRsp
TGetFileChangedRsp.group = {}

local function TGetFileChangedRsp_from_obj(obj)
    return setmetatable(obj, TGetFileChangedRsp)
end

function TGetFileChangedRsp.new(CompletionCode, ManufactureId, Changed)
    return TGetFileChangedRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Changed = Changed
    })
end
---@param obj BiosIpmiCmds.GetFileChangedRsp
function TGetFileChangedRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Changed = obj.Changed
end

function TGetFileChangedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFileChangedRsp.group)
end

TGetFileChangedRsp.from_obj = TGetFileChangedRsp_from_obj

TGetFileChangedRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Changed'}

TGetFileChangedRsp.default = {0, 0, ''}

TGetFileChangedRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Changed', is_array = false, struct = nil}
}

function TGetFileChangedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Changed', self.Changed, 'string', false, errs, need_convert)

    TGetFileChangedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFileChangedRsp.proto_property, errs, need_convert)
    return self
end

function TGetFileChangedRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Changed
end

GetFileChanged.GetFileChangedRsp = TGetFileChangedRsp

return GetFileChanged
