--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDeviceSystemInfo = {}

---@class BiosIpmiCmds.GetDeviceSystemInfoReq
---@field GetOption integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetDeviceSystemInfoReq = {}
TGetDeviceSystemInfoReq.__index = TGetDeviceSystemInfoReq
TGetDeviceSystemInfoReq.group = {}

local function TGetDeviceSystemInfoReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceSystemInfoReq)
end

function TGetDeviceSystemInfoReq.new(GetOption, SetSelector, BlockSelector)
    return TGetDeviceSystemInfoReq_from_obj({
        GetOption = GetOption,
        SetSelector = SetSelector,
        BlockSelector = BlockSelector
    })
end
---@param obj BiosIpmiCmds.GetDeviceSystemInfoReq
function TGetDeviceSystemInfoReq:init_from_obj(obj)
    self.GetOption = obj.GetOption
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetDeviceSystemInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceSystemInfoReq.group)
end

TGetDeviceSystemInfoReq.from_obj = TGetDeviceSystemInfoReq_from_obj

TGetDeviceSystemInfoReq.proto_property = {'GetOption', 'SetSelector', 'BlockSelector'}

TGetDeviceSystemInfoReq.default = {0, 0, 0}

TGetDeviceSystemInfoReq.struct = {
    {name = 'GetOption', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetDeviceSystemInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetOption', self.GetOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)

    TGetDeviceSystemInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceSystemInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceSystemInfoReq:unpack(_)
    return self.GetOption, self.SetSelector, self.BlockSelector
end

GetDeviceSystemInfo.GetDeviceSystemInfoReq = TGetDeviceSystemInfoReq

---@class BiosIpmiCmds.GetDeviceSystemInfoRsp
---@field CompletionCode integer
---@field ParameterRevision integer
---@field Info string
local TGetDeviceSystemInfoRsp = {}
TGetDeviceSystemInfoRsp.__index = TGetDeviceSystemInfoRsp
TGetDeviceSystemInfoRsp.group = {}

local function TGetDeviceSystemInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetDeviceSystemInfoRsp)
end

function TGetDeviceSystemInfoRsp.new(CompletionCode, ParameterRevision, Info)
    return TGetDeviceSystemInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterRevision = ParameterRevision,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetDeviceSystemInfoRsp
function TGetDeviceSystemInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterRevision = obj.ParameterRevision
    self.Info = obj.Info
end

function TGetDeviceSystemInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceSystemInfoRsp.group)
end

TGetDeviceSystemInfoRsp.from_obj = TGetDeviceSystemInfoRsp_from_obj

TGetDeviceSystemInfoRsp.proto_property = {'CompletionCode', 'ParameterRevision', 'Info'}

TGetDeviceSystemInfoRsp.default = {0, 0, ''}

TGetDeviceSystemInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterRevision', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TGetDeviceSystemInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterRevision', self.ParameterRevision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetDeviceSystemInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceSystemInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceSystemInfoRsp:unpack(_)
    return self.CompletionCode, self.ParameterRevision, self.Info
end

GetDeviceSystemInfo.GetDeviceSystemInfoRsp = TGetDeviceSystemInfoRsp

return GetDeviceSystemInfo
