--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetCachedBiosUpgradeMode = {}

---@class BiosIpmiCmds.GetCachedBiosUpgradeModeReq
---@field ManufactureId integer
---@field UpgradeMode string
local TGetCachedBiosUpgradeModeReq = {}
TGetCachedBiosUpgradeModeReq.__index = TGetCachedBiosUpgradeModeReq
TGetCachedBiosUpgradeModeReq.group = {}

local function TGetCachedBiosUpgradeModeReq_from_obj(obj)
    return setmetatable(obj, TGetCachedBiosUpgradeModeReq)
end

function TGetCachedBiosUpgradeModeReq.new(ManufactureId, UpgradeMode)
    return TGetCachedBiosUpgradeModeReq_from_obj({ManufactureId = ManufactureId, UpgradeMode = UpgradeMode})
end
---@param obj BiosIpmiCmds.GetCachedBiosUpgradeModeReq
function TGetCachedBiosUpgradeModeReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.UpgradeMode = obj.UpgradeMode
end

function TGetCachedBiosUpgradeModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCachedBiosUpgradeModeReq.group)
end

TGetCachedBiosUpgradeModeReq.from_obj = TGetCachedBiosUpgradeModeReq_from_obj

TGetCachedBiosUpgradeModeReq.proto_property = {'ManufactureId', 'UpgradeMode'}

TGetCachedBiosUpgradeModeReq.default = {0, ''}

TGetCachedBiosUpgradeModeReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'UpgradeMode', is_array = false, struct = nil}
}

function TGetCachedBiosUpgradeModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UpgradeMode', self.UpgradeMode, 'string', false, errs, need_convert)

    TGetCachedBiosUpgradeModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCachedBiosUpgradeModeReq.proto_property, errs, need_convert)
    return self
end

function TGetCachedBiosUpgradeModeReq:unpack(_)
    return self.ManufactureId, self.UpgradeMode
end

GetCachedBiosUpgradeMode.GetCachedBiosUpgradeModeReq = TGetCachedBiosUpgradeModeReq

---@class BiosIpmiCmds.GetCachedBiosUpgradeModeRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field UpgradeMode integer
local TGetCachedBiosUpgradeModeRsp = {}
TGetCachedBiosUpgradeModeRsp.__index = TGetCachedBiosUpgradeModeRsp
TGetCachedBiosUpgradeModeRsp.group = {}

local function TGetCachedBiosUpgradeModeRsp_from_obj(obj)
    return setmetatable(obj, TGetCachedBiosUpgradeModeRsp)
end

function TGetCachedBiosUpgradeModeRsp.new(CompletionCode, ManufactureId, UpgradeMode)
    return TGetCachedBiosUpgradeModeRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        UpgradeMode = UpgradeMode
    })
end
---@param obj BiosIpmiCmds.GetCachedBiosUpgradeModeRsp
function TGetCachedBiosUpgradeModeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.UpgradeMode = obj.UpgradeMode
end

function TGetCachedBiosUpgradeModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCachedBiosUpgradeModeRsp.group)
end

TGetCachedBiosUpgradeModeRsp.from_obj = TGetCachedBiosUpgradeModeRsp_from_obj

TGetCachedBiosUpgradeModeRsp.proto_property = {'CompletionCode', 'ManufactureId', 'UpgradeMode'}

TGetCachedBiosUpgradeModeRsp.default = {0, 0, 0}

TGetCachedBiosUpgradeModeRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'UpgradeMode', is_array = false, struct = nil}
}

function TGetCachedBiosUpgradeModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UpgradeMode', self.UpgradeMode, 'uint8', false, errs, need_convert)

    TGetCachedBiosUpgradeModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCachedBiosUpgradeModeRsp.proto_property, errs, need_convert)
    return self
end

function TGetCachedBiosUpgradeModeRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.UpgradeMode
end

GetCachedBiosUpgradeMode.GetCachedBiosUpgradeModeRsp = TGetCachedBiosUpgradeModeRsp

return GetCachedBiosUpgradeMode
