--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetBridgeSystemInfo = {}

---@class BiosIpmiCmds.GetBridgeSystemInfoReq
---@field GetOption integer
---@field SetSelector integer
---@field BlockSelector integer
local TGetBridgeSystemInfoReq = {}
TGetBridgeSystemInfoReq.__index = TGetBridgeSystemInfoReq
TGetBridgeSystemInfoReq.group = {}

local function TGetBridgeSystemInfoReq_from_obj(obj)
    return setmetatable(obj, TGetBridgeSystemInfoReq)
end

function TGetBridgeSystemInfoReq.new(GetOption, SetSelector, BlockSelector)
    return TGetBridgeSystemInfoReq_from_obj({
        GetOption = GetOption,
        SetSelector = SetSelector,
        BlockSelector = BlockSelector
    })
end
---@param obj BiosIpmiCmds.GetBridgeSystemInfoReq
function TGetBridgeSystemInfoReq:init_from_obj(obj)
    self.GetOption = obj.GetOption
    self.SetSelector = obj.SetSelector
    self.BlockSelector = obj.BlockSelector
end

function TGetBridgeSystemInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBridgeSystemInfoReq.group)
end

TGetBridgeSystemInfoReq.from_obj = TGetBridgeSystemInfoReq_from_obj

TGetBridgeSystemInfoReq.proto_property = {'GetOption', 'SetSelector', 'BlockSelector'}

TGetBridgeSystemInfoReq.default = {0, 0, 0}

TGetBridgeSystemInfoReq.struct = {
    {name = 'GetOption', is_array = false, struct = nil}, {name = 'SetSelector', is_array = false, struct = nil},
    {name = 'BlockSelector', is_array = false, struct = nil}
}

function TGetBridgeSystemInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'GetOption', self.GetOption, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SetSelector', self.SetSelector, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BlockSelector', self.BlockSelector, 'uint8', false, errs, need_convert)

    TGetBridgeSystemInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBridgeSystemInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetBridgeSystemInfoReq:unpack(_)
    return self.GetOption, self.SetSelector, self.BlockSelector
end

GetBridgeSystemInfo.GetBridgeSystemInfoReq = TGetBridgeSystemInfoReq

---@class BiosIpmiCmds.GetBridgeSystemInfoRsp
---@field CompletionCode integer
---@field ParameterRevision integer
---@field Info string
local TGetBridgeSystemInfoRsp = {}
TGetBridgeSystemInfoRsp.__index = TGetBridgeSystemInfoRsp
TGetBridgeSystemInfoRsp.group = {}

local function TGetBridgeSystemInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetBridgeSystemInfoRsp)
end

function TGetBridgeSystemInfoRsp.new(CompletionCode, ParameterRevision, Info)
    return TGetBridgeSystemInfoRsp_from_obj({
        CompletionCode = CompletionCode,
        ParameterRevision = ParameterRevision,
        Info = Info
    })
end
---@param obj BiosIpmiCmds.GetBridgeSystemInfoRsp
function TGetBridgeSystemInfoRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ParameterRevision = obj.ParameterRevision
    self.Info = obj.Info
end

function TGetBridgeSystemInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBridgeSystemInfoRsp.group)
end

TGetBridgeSystemInfoRsp.from_obj = TGetBridgeSystemInfoRsp_from_obj

TGetBridgeSystemInfoRsp.proto_property = {'CompletionCode', 'ParameterRevision', 'Info'}

TGetBridgeSystemInfoRsp.default = {0, 0, ''}

TGetBridgeSystemInfoRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'ParameterRevision', is_array = false, struct = nil}, {name = 'Info', is_array = false, struct = nil}
}

function TGetBridgeSystemInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ParameterRevision', self.ParameterRevision, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Info', self.Info, 'string', false, errs, need_convert)

    TGetBridgeSystemInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBridgeSystemInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetBridgeSystemInfoRsp:unpack(_)
    return self.CompletionCode, self.ParameterRevision, self.Info
end

GetBridgeSystemInfo.GetBridgeSystemInfoRsp = TGetBridgeSystemInfoRsp

return GetBridgeSystemInfo
